<?php

session_start();
require_once('../../config.php');
require_once("../../lib/loginCheck.php");
require_once("../../lib/database.php");
require_once("../../lib/selectdata.php");
require_once("../../lib/record.php");
require_once("../../lib/validate.php");

loginCheck();

$title = "勤怠時刻編集";

$check = new validate();

# 入力があった場合
if ($_POST["confirm"] == "入力内容確認") {
  $data = $_SESSION["form"];
  $data["confirm"] = $_POST["confirm"];
  unset($_SESSION["form"]);
  $data["date"] = sprintf("%04d-%02d-%02d", $data["year"], $data["month"], $data["day"]);

  $data["start"] = $_POST["start"];
  if (!empty($data["start"])) {
    if (!$check->input_time($data["start"]))
      $msg[] = "時間は HH:MM（24時間表記）の形式で入力してください（例： 09:00）";
    $data["finish"] = $_POST["finish"];
    if (!$check->input_time($data["finish"]) && !empty($_POST["finish"]))
      $msg[] = "時間は HH:MM（24時間表記）の形式で入力してください（例：17:00）";
  } else {
    $msg[] = "始業時刻を入力してください";
  }
  $data["remarks"] = $_POST["remarks"];
  if (!preg_match("/.{0,100}/", $_POST["remarks"]))
    $msg[] = "備考は100文字以内で入力してください";

  $_SESSION["form"] = $data;
  if (!count($msg)) header('location: edit_confirm.php');
} else {
  if (isset($_SESSION["form"]["back"]) && $_SESSION["form"]["back"] == "戻る") {
# 確認画面から戻ってきた場合
    $data = $_SESSION["form"];
    unset($_SESSION["form"]);
  } else {
    unset($_SESSION["form"]);
    $d = array("日", "月", "火", "水", "木", "金", "土");
    preg_match_all("/(\d{4})-?(\d{2})-?(\d{2})/", $_GET["date"], $m);

    $data["year"] = !empty($m[1][0]) ? $m[1][0] : date("Y");
    $data["month"] = !empty($m[2][0]) ? $m[2][0] : date("m");
    $data["day"] = !empty($m[3][0]) ? $m[3][0] : date("d");

    $data["staff_id"] = $_SESSION["session_staff_id"];
    $db = new database();

    $data["name"] = get_name($data["staff_id"], $db);
    $data = get_record($data, $db);
    $data["d"] =$d[date("w", strtotime($data["year"] . $data["month"] . $data["day"]))];
  }

  $_SESSION["form"] = $data;
}

foreach($data as $k => $v) {
  $data[$k] = htmlspecialchars($v);
}


header("Content-type: text/html; charset=utf-8");
include('../../template/header.html');
include('../../template/menu.html');
include('../../template/list_edit.html');
include('../../template/footer.html');


?>