<?php

session_start();
require_once('../../config.php');
require_once("../../lib/loginCheck.php");
require_once("../../lib/database.php");
require_once("../../lib/validate.php");

loginCheck();

$title = "時刻入力";

$check = new validate();

$d = array("日", "月", "火", "水", "木", "金", "土");
$data["date"] = date("Y年m月d日");
$data["day"] = $d[date("w")] . "曜日";
$data["now"] = date("H:i");


# 始業ボタンが押されたら
$data["confirm"] = $_POST["confirm"];
if (isset($data["confirm"])) {
  foreach($date_name as $k) {
    unset($_SESSION[$k]);
  }
  if ($data["confirm"] == "時刻入力") {
    $msg = array();
    preg_match_all("/\d+/", $_POST["date"], $m);
    $data["date"] = checkdate($m[0][1], $m[0][2], $m[0][0]) ? $_POST["date"] : "";
    $data["start"] = $check->input_time($_POST["start"]) ? $_POST["start"] : "";
    if (empty($data["start"])) $msg[] = "時間は HH:MM（24時間表記）の形式で入力してください（例： 09:00）";
    if (!empty($_POST["finish"])) {
      if ($check->input_time($_POST["finish"])) {
      $data["finish"] = $_POST["finish"];
      } else {
      $msg[] = "時間は HH:MM（24時間表記）の形式で入力してください（例： 09:00）";
      }
    }
    $data["remarks"] = preg_match("/.{1,200}/", $_POST["remarks"]) ? $_POST["remarks"] : "";

# エラーメッセージがなかったら確認画面へ
    if (count($msg) == 0) {
      foreach($date_name as $k) {
        if (!empty($data[$k])) $_SESSION[$k] = $data[$k];
      }
      header('location: confirm.php');
    }
  }
}

# 確認画面から戻ってきた場合
if (isset($_SESSION["back"]) && $_SESSION["back"] == "戻る") {
  unset($_SESSION["back"]);
  foreach($date_name as $k) {
    $data[$k] = $_SESSION[$k];
    unset($_SESSION[$k]);
  }
} else {
  $db = new database();
  $sql = "SELECT * FROM timerecord WHERE staff_id='"
    . $_SESSION["session_staff_id"]
      . "' AND date ='"
        . date("Y-m-d")
          . "' AND finish IS NULL";
  $res = $db->query($sql);


  $row = mysql_fetch_array($res);
  if (!empty($row)) {
    $finish_flag = 1;
    preg_match_all("/\d+/", $row["date"], $m);
    $data["date"] = $m[0][0] . "年" . $m[0][1] . "月" . $m[0][2] . "日";
    $data["start"] = preg_replace("/^.+\s|:\d\d$/", "", $row["start"]);
    $data["remarks"] = $row["remarks"];
    $data["now"] = !empty($data["finish"]) ? $data["finish"] : date("H:i");
  }
}
if (!empty($data["finish"])) $finish_flag = 1;
     foreach($date_name as $k => $v) {
       $data[$k] = htmlspecialchars($data[$k]);
     }


header("Content-type: text/html; charset=utf-8");
include('../../template/header.html');
include('../../template/menu.html');
include('../../template/input.html');
include('../../template/footer.html');
?>