<?php

session_start();
require_once('../../config.php');
require_once("../../lib/loginCheck.php");
require_once("../../lib/database.php");

loginCheck();

$title = "時刻入力 内容確認";

if ($_SESSION["confirm"] != "時刻入力") {
  header("location: index.php");
}

foreach($date_name as $k) {
  $data[$k] = !empty($_SESSION[$k]) ? $_SESSION[$k] : "";
}

// 確定ボタンが押されたら
if (isset($_POST["submit"])) {
  if ($_POST["submit"] == "確定") {
    $_SESSION["submit"] = $_POST["submit"];
  }

  $date = preg_replace("/\D/", "-", $_SESSION["date"]);
  $start = $date . " " . preg_replace("/:/", "-", $_SESSION["start"]);
  if (!empty($_SESSION["finish"]))
    $finish = $date . " " . preg_replace("/:/", "-", $_SESSION["finish"]);
  $remarks = $_SESSION["remarks"] == "備考" ? "" : $_SESSION["remarks"];



  $db = new database();
  $fields = array("date", "start", "break", "remarks", "staff_id");
  $values = array($date, $start, BREAKTIME, $remarks, $_SESSION["session_staff_id"]);
  if (empty($finish)) {
    $res = $db->insert("timerecord", $fields, $values);
  } else {
    $fields[] = "finish";
    $values[] = $finish;
    for ($i = 0; $i < count($fields); $i++) {
      $v[$fields[$i]] = $values[$i];
    }
    $condition = "staff_id ='"
      . $_SESSION["session_staff_id"]
        . "' AND date ='"
          . $date
            . "' AND finish IS NULL";

    $res = $db->update("timerecord", $v, $condition);
  }

  if ($res) {
    header('location: ../list/index.php');
  }

} elseif (isset($_POST["back"])) {
  $_SESSION["back"] = ($_POST["back"] == "戻る") ? $_POST["back"] : "戻る";
  header('location: index.php');
}

foreach($date_name as $k) {
  $data[$k] = htmlspecialchars($data[$k]);
}

header("Content-type: text/html; charset=utf-8");
include('../../template/header.html');
include('../../template/menu.html');
include('../../template/input_conf.html');
include('../../template/footer.html');

?>