<?php

session_start();
require_once('../../config.php');
require_once("../../lib/loginCheck.php");
require_once("../../lib/database.php");

loginCheck();

$title = "登録内容編集 入力内容確認";

if ($_SESSION["confirm"] != "入力内容確認") {
  header("location: index.php");
}


foreach($reg_name as $k) {
  $data[$k] = !empty($_SESSION[$k]) ? $_SESSION[$k] : "";
}


if (isset($_POST["submit"])) {
  if ($_POST["submit"] == "登録") {
    $_SESSION["submit"] = $_POST["submit"];
  }
  $full_fields = array("staff_id");
  if (!empty($data["password"])) {
    $data["password"] = sha1($data["password"]);
    $full_fields[] = "password";
  }
  $data["update_at"] = date("Y-m-d H:i:s");


  $db = new database();

  array_push($full_fields, "name", "email", "tel", "update_at");

  foreach($full_fields as $k) {
    if ($k == "staff_id") {
      $v[$k] = $_SESSION["staff_id"];
    } else {
      $v[$k] = $data[$k];
    }
  }

  $res = $db->update("staff", $v,
                     "staff_id='" . $db->escape($data["staff_id"]) . "'");

  if ($res) {
    header('location: comp.php');
  } else {
    $data["name"] = $db->sql;
  }


} elseif (isset($_POST["back"])) {
  $_SESSION["back"] = ($_POST["back"] == "戻る") ? $_POST["back"] : "戻る";
  header('location: index.php');
}

$title = "登録内容確認";

foreach($reg_name as $k) {
  $data[$k] = htmlspecialchars($data[$k]);
}

$data["password"] = preg_replace('/\w/i', '*', $data["password"]);
$data["password2"] = preg_replace('/\w/i', '*', $data["password2"]);

header("Content-type: text/html; charset=utf-8");
include('../../template/header.html');
include('../../template/menu.html');
include('../../template/confirm.html');
include('../../template/footer.html');

?>