<?php

class validate {

  function staff_id($str) {
    if (preg_match('/^\w{1,20}$/', $str)) {
      return TRUE;
    } else {
      return FALSE;
    }
  }

  function password($str) {
    if (preg_match('/^\w{4,12}$/', $str)) {
      return TRUE;
    } else {
      return FALSE;
    }
  }

  function tel($str) {
    $len = strlen($str);
    if ($len < 30) {
      if (preg_match("/\d+\-?\d+\-?\d{4}/", $str)) {
        return TRUE;
      } elseif ($len == 0) {
        return TRUE;
      }
    } else {
      return FALSE;
    }
  }



  function email($str) {
    if (strlen($str) == 0) {
      return TRUE;
    }elseif (strlen($str) > 0 && preg_match("/^[a-zA-Z0-9_\.\-]+@(([a-zA-Z0-9_\-]+\.)+[a-zA-Z0-9]+$)/", $str)) {
      return TRUE;
    } else {
      return FALSE;
    }
  }

  function required ($str) {
    if (mb_strlen($str) > 0) {
      return TRUE;
    } else {
      return FALSE;
    }
  }

  function min_length($str, $len) {
    if (mb_strlen($str) >= $len) {
      return TRUE;
    } else {
      return FALSE;
    }
  }

  function max_length($str, $len) {
    if (mb_strlen($str) <= $len) {
      return TRUE;
    } else {
      return FALSE;
    }
  }

  function input_time($str) {
    if (empty($str)) return FALSE;
    if (preg_match("/^\d{2}:\d{2}$/", $str)) {
      return TRUE;
    } else {
      FALSE;
    }
  }
}



?>