addEvent(window, "load", function() {
  var input = document.getElementsByTagName("input");
  for (var i = 0; i < input.length; i++) {
    if (input[i].type == "text") {
      if (input[i].getAttribute("readonly") == "readonly") continue;
      input[i].focus();
      break;
    }
  }

  if ($("check_id")) {
    var checkButton = createElm("input",
                                {type: "button", value: "社員番号をチェック"},
                                {fontSize: "80%", padding: "2px", margin: "2px"});
    $("check_id").parentNode.appendChild(document.createElement("br"));
    $("check_id").parentNode.appendChild(checkButton);

    addEvent(checkButton, "click", function() {
      var staff = $("check_id").value;
      if (!staff) return msg_disp("社員番号を入力してください");
      if (!/^\w+$/.test(staff)) return msg_disp("半角英数字で入力してください");
      if (!/^\w{1,20}$/.test(staff)) return msg_disp("20文字以内で入力してください");
      var data = "id=" + encodeURIComponent($("check_id").value);
      xhr.open("POST", "../../ajax/check_id.php", true);
      xhr.onreadystatechange = function () {
        if (xhr.readyState == 4) {
          res = xhr.responseText;
          if (res == "OK!") {
            msg_disp("OK!");
          }
          if (res == "NG!") {
            msg_disp("この社員番号はすでに使われています");
          }
        }
      }
      if (xhr.readyState != 4) {
        msg_disp("チェック中...");
      }
      xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
      xhr.send(data);

      function msg_disp(msg) {
        var node = $("check_id").parentNode;
        if (node.lastChild.nodeName == "#text") {
          node.replaceChild(document.createTextNode(msg), node.lastChild);
        } else {
          node.appendChild(document.createTextNode(msg));
        }
      }
    });
  }

  if ($("remarks")) {
    addEvent($("remarks"), "focus", function(e) {
      var elm = e.target || e.srcElement;
      if (!elm.getAttribute("readonly")) {
        elm.value = elm.value == "備考" ? "" : elm.value;
      }
    });
  }
});