Array.prototype.random = function() {
  return this[Math.floor(Math.random() * this.length)];
}

function $(e) {
  if(typeof e=='string') e = document.getElementById(e);
  return e
  };

var addEvent = (function() {
  if (window.addEventListener) {
    return function(el, type, fn) {
      el.addEventListener(type, fn, false);
    };
  } else if (window.attachEvent) {
    return function(el, type, fn) {
      var f = function() {
        fn.call(el, window.event);
      };
      el.attachEvent('on'+type, f);
    };
  } else {
    return function(el, type, fn) {
      element['on'+type] = fn;
    }
  }
})();

var xhr = (function() {
if (window.XMLHttpRequest) {
  // Firefox、Safari、Internet Explorer 7.0など向け
  return new XMLHttpRequest();
} else {
  // Internet Explorer 6.0以前向け
  try {
    return new ActiveXObject("Msxml2.XMLHTTP"); // 6.0用
  } catch(e) {
    try {
      return new ActiveXObject("Microsoft.XMLHTTP"); // 5.5以前用
    } catch(e) {
      return null;
    }
  }
}
})();


var createElm = function(tag, attr, css) {
  var elm = document.createElement(tag);
  var style = elm.style;
  for (var k in attr) {
    elm.setAttribute(k, attr[k]);
  }
  for (var k in css) {
    style[k] = css[k];
  }
  return elm;
}

