<?php

session_start();
require_once("../../lib/validate.php");
require_once("../../config.php");
require_once("../../lib/loginCheck.php");
require_once("../../lib/checkId.php");

adminCheck();

$title = "新規社員登録";

$data["confirm"] = $_POST["confirm"];
if (isset($data["confirm"])) {
  if ($data["confirm"] == "入力内容確認") {
    $err_msg = array();
    $check = new validate();

# 社員番号チェック
    if (!$check->required($_POST["staff_id"])) {
      $err_msg[] = "社員番号を入力して下さい";
    } elseif (!$check->staff_id($_POST["staff_id"])) {
      $err_msg[] = "社員番号は半角英数字で入力して下さい";
    }
    if (!checkId($_POST["staff_id"])) $err_msg[] = "社員番号がすでに使われています";
# 名前チェック
    if (!$check->required($_POST["name"])) {
      $err_msg[] = "名前を入力して下さい";
    } elseif (!$check->max_length($_POST["name"], 100)) {
      $err_msg[] = "名前は100文字以内で入力して下さい";
    }
# パスワードチェック
    if (!$check->password($_POST["password"])) {
      $err_msg[] = "パスワードは4～12文字で入力して下さい";
    } elseif ($_POST["password"] != $_POST["password2"]) {
      $err_msg[] = "パスワードが一致しません";
    }
# メールチェック
    if (!$check->email($_POST["email"])) {
      $err_msg[] = "メールアドレスは半角英数字で入力して下さい（例：abcdef@example.com）";
    } elseif (!$check->max_length($_POST["email"], 200)) {
      $err_msg[] = "メールアドレスは200文字以内で入力して下さい";
    }
# 電話番号チェック
    if (!$check->tel($_POST["tel"])) {
      $err_msg[] = "電話番号は半角数字（ハイフンなし）で入力して下さい（例：1234567890）";
    } elseif (!$check->max_length($_POST["tel"], 10)) {
      $err_msg[] = "電話番号は10文字以内で入力して下さい";
    }

# 所属チェック
    if (!$check->max_length($_POST["division"], 100)) {
      $err_msg[] = "所属は100文字以内で入力して下さい";
    }
# 管理者フラグチェック
    if ($_POST["admin"] != 1) {
      $_POST["admin"] = "";
    }

    foreach($reg_name as $k) {
      $data[$k] = $_POST[$k];
    }

# エラーメッセージがなかったら確認画面へ
    if (count($err_msg) == 0) {
      foreach($reg_name as $k) {
        $_SESSION[$k] = $data[$k];
      }
      header('location: confirm.php');
    }
  }
}

# 確認画面から戻ってきた場合
if (isset($_SESSION["back"]) && $_SESSION["back"] == "戻る") {
  foreach($reg_name as $k) {
    $data[$k] = $_SESSION[$k];
  }

  $_SESSION = array();
}

foreach($data as $k => $v) {
  $data[$k] = htmlspecialchars($data[$k]);
}

header("Content-type: text/html; charset=utf-8");
include('../../template/header.html');
include('../../template/admin_menu.html');
include('../../template/register.html');
include('../../template/footer.html');

?>