<?php

session_start();
require_once('../../config.php');
require_once('../../lib/database.php');
require_once("../../lib/loginCheck.php");

adminCheck();

$title = "新規社員登録 入力内容確認";

if ($_SESSION["confirm"] != "入力内容確認") {
  header("location: index.php");
}

foreach($reg_name as $k) {
  $data[$k] = $_SESSION[$k];
}


if (isset($_POST["submit"])) {
  if ($_POST["submit"] == "登録") {
    $_SESSION["submit"] = $_POST["submit"];
  }

  $data["password"] = sha1($data["password"]);
  $data["datetime"] = date("Y-m-d H:i:s");



  $db = new database();

  $values = array($data["staff_id"],
                  $data["name"],
                  $data["password"],
                  $data["email"],
                  $data["division"],
                  $data["tel"],
                  $data["admin"],
                  $data["datetime"]);

  $res = $db->insert("staff", array(staff_id, name, password, email, division, tel, admin, create_at), $values);

  if ($res) {
    header('location: comp.php');
  } else {
    $msg = "社員登録に失敗しました。";
  }


} elseif (isset($_POST["back"])) {
  $_SESSION["back"] = ($_POST["back"] == "戻る") ? $_POST["back"] : "戻る";
  header('location: index.php');
}

foreach($reg_name as $k) {
  $data[$k] = htmlspecialchars($data[$k]);
}

$data["password"] = preg_replace('/\w/i', '*', $data["password"]);
$data["password2"] = preg_replace('/\w/i', '*', $data["password2"]);

header("Content-type: text/html; charset=utf-8");
include('../../template/header.html');
include('../../template/admin_menu.html');
include('../../template/admin_confirm.html');
include('../../template/footer.html');

?>