<?php

session_start();
require_once('../../config.php');
require_once("../../lib/loginCheck.php");
require_once("../../lib/database.php");
require_once("../../lib/selectdata.php");

adminCheck();

preg_match_all("/(\d{4})-?(\d{2})/", $_GET["list"], $m);
$year = !empty($m[1][0]) ? $m[1][0] : date("Y");
$month = !empty($m[2][0]) ? $m[2][0] : date("m");
$data["staff_id"] = preg_match("/^\w+$/", $_GET["staff"]) ? $_GET["staff"] : "";

$d = array("日", "月", "火", "水", "木", "金", "土");

$title = $year . "年" . $month . "月" . "の一覧";

// リスト作成
if (CUTOFF == 0) {
  $mo = $month;
  $end_day = date('t', $mo);
} else {
  $mo = $month - 1;
  $end_day = CUTOFF;
}
$y = $year;
// 1月の場合
if (!$mo) {
  $mo = 12;
  $y = $year - 1;
}

for ($i = CUTOFF + 1; checkdate($mo, $i, $y); $i++) {
  $day[] = sprintf("%04d%02d%02d", $y, $mo, $i);
}
for ($i = 1; checkdate($month, $i, $year) && $i <= CUTOFF; $i++) {
  $day[] = sprintf("%04d%02d%02d", $year, $month, $i);
}


$db = new database();

$ym = select_menu($data["staff_id"], $db);

$data["name"] = get_name($data["staff_id"], $db);


$sql = "SELECT staff_id, date, start, finish, break, remarks FROM timerecord WHERE staff_id='"
. $data["staff_id"]
. "' AND del_flag IS NULL AND date >='"
. sprintf("%04d-%02d-%02d", $y, $mo, CUTOFF + 1)
. "' AND date <='"
. sprintf("%04d-%02d-%02d", $year, $month, $end_day)
. "' ORDER BY date";

$res = $db->query($sql);
$rows = array();

while ($row = mysql_fetch_array($res)) {
  $r["date"] = !empty($row["date"]) ? preg_replace("/\-/", "", $row["date"]) : "";
  $r["day"] = !empty($row["date"]) ? $d[date("w", strtotime($row["date"]))] : "";
  $r["start"] = !empty($row["start"]) ? preg_replace("/^.+\s|:\d\d$/", "", $row["start"]) : "";
  $r["finish"] = !empty($row["finish"]) ? preg_replace("/^.+\s|:\d\d$/", "", $row["finish"]) : "";
  $r["break"] = !empty($row["break"]) ? $row["break"] : "";
  $r["remarks"] = !empty($row["remarks"]) ? $row["remarks"] : "";
  preg_match_all("/(\d\d):(\d\d)/", $r["start"], $m);
  $h = $m[1][0];
  $min = $m[2][0];
  if (!empty($r["start"])) {
    if ($min < 30 && $min != "00") $r["start"] = $h . ":" . "30";
    if ($min > 30) $r["start"] = sprintf("%02d:%02d",
                                         $h + 1,
                                         "00");
  }
  if (!empty($row["finish"])) {
    preg_match_all("/(\d\d):(\d\d)/", $r["finish"], $m);
    $h = $m[1][0];
    $min = $m[2][0];
    if ($min > 30 && $min != "00") $r["finish"] = $h . ":" . "30";
    if ($min < 30) $r["finish"] = $h . ":" . "00";
    $start = preg_replace("/\d\d:\d\d:\d\d/", $r["start"], $row["start"]);
    $finish = preg_replace("/\d\d:\d\d:\d\d/", $r["finish"], $row["finish"]);
    $time = strtotime($finish) - strtotime($start) - $r["break"] * 60;
    $r["time"] = time_to_str($time);
    $data["sum"] += $time;
  } else {
    $r["time"] = "";
  }
  $rows[] = $r;
}
function time_to_str($sec) {
  $h = floor($sec / (60 * 60));
  $re = floor($sec % (60 * 60));
  $m = floor($re / 60);
  return sprintf("%02d:%02d", $h, $m);
}

$data["sum"] = time_to_str($data["sum"]);

foreach ($day as $k) {
  $l["date"] = htmlspecialchars($k);
  $l["day"] = htmlspecialchars($d[date("w", strtotime($k))]);
  $l["start"] = "";
  $l["finish"] = "";
  $l["break"] = "";
  $l["remarks"] = "";
  $l["time"] = "";
  foreach ($rows as $row) {
    if (!strcmp($k, $row["date"])) {
      $l["start"] = htmlspecialchars($row["start"]);
      $l["finish"] = htmlspecialchars($row["finish"]);
      $l["break"] = htmlspecialchars($row["break"]);
      $l["remarks"] = htmlspecialchars($row["remarks"]);
      $l["time"] = htmlspecialchars($row["time"]);
      break;
    }
  }
  $list[] = $l;
}

foreach($data as $k) {
  $data[$k] = htmlspecialchars($data[$k]);
}

header("Content-type: text/html; charset=utf-8");
include('../../template/header.html');
include('../../template/admin_menu.html');
include('../../template/list.html');
include('../../template/footer.html');

?>