/*
 kstrax_buffer headler for ia64
 Copyright (c) 2005,2006 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __KSTRAX_BUF_ARCH_H__
#define __KSTRAX_BUF_ARCH_H__

#include <stdio.h>
#include <time.h>

#define __IS_NO_PAIR if(buffer->sys_call_number == KS_EXIT || \
			buffer->sys_call_number == KS_RT_SIGRETURN || \
			buffer->sys_call_number == KS_EXIT_GROUP)
#define __SET_UTIME(var) (var->time % 1000000)
/* max value of long long int */
#define PROC_TIME_MAX  LONG_MAX
#define PRINT_END      -1

typedef long proc_time_t;
typedef long syscall_count_t;

typedef struct sys_call_info {
	pid_t pid;
	short sys_call_number;
	long time;
	long arg_1;
	union {
		long arg_2;
		long return_value;
	};
	long arg_3;
	long arg_4;
	long arg_5;
	long arg_6;
	long serial;
	long cpu;
} buffer_t;

typedef struct kstrax_list_entry {
	struct kstrax_list_entry *next;
	buffer_t buf;
} kst_list_entry_t;

typedef struct kstrax_basetime {
	long g_t_d;         /* time of gettimeofday */
	long t_s_c;         /* time of tsc */
	long hz;            /* cpu freq (hz) */
} basetime_t;

typedef struct kstrax_per_cpu {
	buffer_t buf;
	basetime_t basetime;
	int fd;
} per_cpu_t;

typedef struct kstrax_statistics {
	unsigned long count;
	unsigned long nr_error;
	unsigned long nr_no_entry;
	unsigned long nr_no_return;
	proc_time_t max_time;
	proc_time_t min_time;
	proc_time_t total_time;
} statistics_t;

typedef struct kstrax_print_data {
	buffer_t *buf;
	kst_list_entry_t **hash_table;
	kst_list_entry_t *free_list;
	statistics_t *stats;
	FILE *w_fp;
} print_data_t;

extern long kstrax_first_time;
extern long kstrax_sum_proc_time[];
extern long kstrax_sum_count[];

static inline basetime_t __get_basetime(const buffer_t *buf)
{
	basetime_t retval;

	if (buf->pid != KS_BASETIME) {
		fprintf(stderr, "error:invalid header\n");
		exit(1);
	}
	
	retval.g_t_d = buf->arg_1 * 1000000 + buf->arg_2; /* mu sec */
	retval.t_s_c = buf->time;
	retval.hz = buf->arg_3;
	
	return retval;
}

static inline void __tsc_to_gtd(per_cpu_t *kst_data)
{
	long tmp_tsc;

	tmp_tsc = kst_data->buf.time;
	tmp_tsc -= kst_data->basetime.t_s_c;	
	tmp_tsc = (tmp_tsc * 10 / kst_data->basetime.hz + 5) / 10;

	kst_data->buf.time = kst_data->basetime.g_t_d;
	kst_data->buf.time += tmp_tsc;
}

static inline struct tm __set_time(const buffer_t *arg)
{
	long tmp_time = arg->time / 1000000;
	return (*localtime((const time_t *)&tmp_time));
}

static inline void __print_pair_entry_graph(const buffer_t *call,
					    const buffer_t *ret,
					    FILE *w_fp)
{
	int i;

	if (kstrax_first_time == 0)
		kstrax_first_time = ret->time;	

	fprintf(w_fp, "%ld ", ret->time - kstrax_first_time);	
//#if 0
	for (i = 0; i < NR_syscalls; i++) {
		if (call->sys_call_number == i) {
			fprintf(w_fp, "%ld ", ret->time - call->time);
			kstrax_sum_proc_time[i] += (ret->time - call->time);
			kstrax_sum_count[i]++;
		}
		else 
			fprintf(w_fp, "?0 ");
	}
	fprintf(w_fp, "\n");
//#endif
}
static inline void __print_syscall_count(FILE *fp,
					 syscall_count_t total,
					 syscall_count_t lost)
{
	fprintf(fp, "\n\ntotal syscalls      :: %ld\n"
		"total lost syscalls :: %ld\n",
		total / 2, lost / 2);
}

static inline void __print_syscall_name(FILE *fp, const buffer_t *buf)
{
	fprintf(fp, "%s", syscall_name[abs(buf->sys_call_number)].name);
}

static inline void __print_syscall_name_stats(FILE *fp, int index)
{
	fprintf(fp, "%3d  %-24s  ", index, syscall_name[index].name);
}

static inline void __print_syscall_name_stats_graph(FILE *fp, int index)
{
	fprintf(fp, "%d ", index);
}

static inline void __print_syscall_arg(FILE *w_fp, const buffer_t *buf)
{
	int i;
	long *ptr;
	int num = buf->sys_call_number;
	
	fprintf(w_fp, "(");
	if (num < 0) {
		fprintf(w_fp, " --- ");
	} else {
		for(i = 0; i < syscall_name[num].args_number; i++) {
			if (i == 0) 
				ptr = (long *)&buf->arg_1;
			else
				fprintf(w_fp, ", ");
			
			fprintf(w_fp, "0x%lx", *ptr);
			ptr++;
		}
	}
	fprintf(w_fp, ")");
}

static inline int __print_sigreturn_normal(kst_list_entry_t **entry1,
					   buffer_t *buf,
					   print_data_t *p_data)
{
	/* dummy function */
	return 0;
}

static inline void __print_sigreturn_raw(buffer_t *buf,
					 print_data_t *p_data)
{
	/* dummy function */
	return;
}

static inline int __print_sigreturn_stats(kst_list_entry_t **entry1,
					  buffer_t *buf,
					  print_data_t *p_data)
{
	/* dummy function */
	return 0;
}

static inline int __get_nr_stats(void)
{
	return NR_syscalls;
}

static inline int __get_stats_array_index(const buffer_t *buf)
{
	return buf->sys_call_number;
}

static inline proc_time_t __calc_processing_time(const buffer_t *call, 
						 const buffer_t *ret)
{
	return (ret->time - call->time);
}

static inline void __print_proc_time(FILE *fp, proc_time_t p_time)
{
	fprintf(fp, "%6ld.%06lu  ", p_time / 1000000, 
		(unsigned long)p_time % 1000000);
}

static inline void __print_proc_time_graph(FILE *fp, proc_time_t p_time)
{
	fprintf(fp, "%ld.%06lu ", p_time / 1000000, 
		(unsigned long)p_time % 1000000);
}
#endif  /* __KSTRAX_BUF_ARCH_H__ */
