/*
 kstrax header file for ia64
 Copyright (c) 2006 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __KSTRAX_ARCH_H__
#define __KSTRAX_ARCH_H__

#include "kstrax_ioc.h"
#include "syscall_name.h"

static inline void __kstrax_specify_socketcall_ipc(int *flag_specified,
						   int *ioctl_arg,
						   char *optarg)
{
	/* dummy function */
}

static void __kstrax_status_print_syscall_name(struct kstrax_status *status)
{
	int i;

	for (i = 0; i < NR_syscalls; i++) {
		if (status->trace_syscall[i] == 1)
			printf("%s ", syscall_name[i].name);
	}
	printf("\n");
}


static inline void __kstrax_restore_trace_syscall(struct kstrax_status *old,
						  struct kstrax_status *new,
						  int fd)
{
	int i;

	for (i = 0; i < NR_syscalls; i++) {
		if (old->trace_syscall[i] != new->trace_syscall[i]) {
			if (ioctl(fd, KSTRAX_IOC_SYSCALL_SPEC, &i) < 0) {
				perror("kstrax_restore_status(ioctl)");
				exit(1);
			}
		}
	}
}

#endif  /* __KSTRAX_ARCH_H__ */
