/*
 kstrax header file for i386
 Copyright (c) 2006 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __KSTRAX_ARCH_H__
#define __KSTRAX_ARCH_H__

#include "kstrax_ioc.h"
#include "syscall_name.h"

static inline void __kstrax_specify_socketcall_ipc(int *flag_specified,
						   int *ioctl_arg,
						   char *optarg)
{
	int i;
	
	/* specified socketcall syscall */
	if (*flag_specified == 0) {
		for (i = 1; i < NR_SOCKETCALL; i++) {
			if (strcmp(optarg, socketcall_syscall_name[i].name) != 0)
				continue;
			*flag_specified = 1;
			*ioctl_arg = -i - 7;
		}
	}

	/* specified ipc syscall */
	if (*flag_specified == 0) {
		int arg[NR_IPC] = {117, -25, -26, -27, -28, 117, 117, 117,
				   117, 117, 117, -29, -30, -31, -32, 117,
				   117, 117, 117, 117, 117, -33, -34, -35, -36};
		for (i = 1; i < 25; i++) {
			/* no ipc call */
			if ((4 < i && i < 11) || (14 < i && i < 21))
				continue;

			if (strcmp(optarg, ipc_syscall_name[i].name) != 0)
				continue;

			*flag_specified = 1;
			*ioctl_arg = arg[i];
		}
	}
}

static inline void __kstrax_status_print_syscall_name(struct kstrax_status *status)
{
	int i, j;

	for (i = 0; i < NR_syscalls; i++) {
		if (i == KS_SOCKETCALL) {
			for (j = 0; j < NR_SOCKETCALL; j++) {
				if (status->trace_socketcall[j] == 0)
					continue;
				printf("%s ", socketcall_syscall_name[j].name);
			}
		} else if (i == KS_IPC) {
			for (j = 0; j < NR_IPC; j++) {
				if (status->trace_ipc[j] == 0)
					continue;
				if (ipc_syscall_name[j].name == NULL)
					continue;
				printf("%s ", ipc_syscall_name[j].name);
			}
		} else if (status->trace_syscall[i] == 1)
			printf("%s ", syscall_name[i].name);
	}
	printf("\n");
}

static inline void __kstrax_restore_trace_syscall(struct kstrax_status *old,
						  struct kstrax_status *new,
						  int fd)
{
	int i;

	for (i = 0; i < NR_syscalls; i++) {
		if (i == KS_SOCKETCALL || i == KS_IPC)
			continue;
		if (old->trace_syscall[i] != new->trace_syscall[i])
			if (ioctl(fd, KSTRAX_IOC_SYSCALL_SPEC, &i) < 0) {
				perror("kstrax_restore_status(ioctl)");
				exit(1);
			}
	}

	if ((old->trace_syscall[KS_SOCKETCALL] != 
	     new->trace_syscall[KS_SOCKETCALL]) ||
	    (old->trace_syscall[KS_SOCKETCALL] == 1 && 
	     new->trace_syscall[KS_SOCKETCALL] == 1)) {
		for (i = 0; i < NR_SOCKETCALL; i++) {
			int arg;
			if (old->trace_socketcall[i] != new->trace_socketcall[i]) {
				if (i == 0)
					arg = KS_SOCKETCALL;
				else
					arg = -i - 7;
				if (ioctl(fd, KSTRAX_IOC_SYSCALL_SPEC, 
					  &arg) < 0) {
					perror("kstrax_restore_status(ioctl)");
					exit(1);
				}
			}
		}
	}

	if ((old->trace_syscall[KS_IPC] != new->trace_syscall[KS_IPC]) ||
	    (old->trace_syscall[KS_IPC] == 1 && new->trace_syscall[KS_IPC] == 1)) {
		int arg[NR_IPC] = {KS_IPC, -25, -26, -27, -28, 0, 0, 0, 0, 0,
				   0, -29, -30, -31, -32, 0, 0, 0, 0, 0, 
				   0, -33, -34, -35, -36};
		for (i = 0; i < NR_IPC; i++) {
			if ((4 < i && i < 11) || (14 < i && i < 21))
				continue;
			if (old->trace_ipc[i] != new->trace_ipc[i]) {
				if (ioctl(fd, KSTRAX_IOC_SYSCALL_SPEC, 
					  &arg[i]) < 0) {
					perror("kstrax_restore_status(ioctl)");
					exit(1);
				}
			}
		}
	}
}

#endif  /* __KSTRAX_ARCH_H__ */
