/***************************************************************************
                          varDlg.cpp  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>

// include files for Qt
#include <qdatetime.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qptrlist.h>

// include files for KDE
#include <klocale.h>

// application specific includes
#include "docTables.h"
#include "commonWgt.h"
#include "varDlg.h"

/////////////////////////////////////////////////////////////////////////////
// VarDlg - Variable Setting Dialog

//
// Constructor
VarDlg::VarDlg( const QString& fn, UserTbl* ev, bool mflg ) :
  KDialog(), mailFlag(mflg)
{


  QVBoxLayout* v = new QVBoxLayout( this, marginHint(), spacingHint() );
  {
    // File Group Box
    CGroupBox* g = new CGroupBox( i18n("File"), this );
    v->addWidget( g );
    QVBoxLayout* v1 = new QVBoxLayout( g->layout() );
    {
      // File Name
      v1->addWidget( new FrameLabel( fn, g ) );
    }
    {
      // Header Commnet
      v1->addWidget( new QLabel( i18n("Comment"), g ) );
      hedTed = new QTextEdit( g );
      hedTed->setWordWrap( QTextEdit::NoWrap );
      hedTed->setMinimumSize( QSize( 0, 30 ) );
      hedTed->setText( ev->Head );
      v1->addWidget( hedTed );
      connect( hedTed, SIGNAL( textChanged() ),
                 this, SLOT ( slotHeaderChanged() ) );
    }
  }

#ifdef CRON_DILLON
mflg = false;
mailFlag = false;
#endif 
  if ( mflg ) {
    // Mail Group Box ( 'cron' Variable )
    mailGrp = new CButtonGroup( i18n("Mail"), this );
    v->addWidget( mailGrp );
    QHBoxLayout* h = new QHBoxLayout( mailGrp->layout() );
    {
      // Mail Mode Select
      h->addWidget( new QRadioButton( i18n("Mail Off"), mailGrp ) );
      h->addWidget( new QRadioButton( i18n("Mail to crontab's owner"), mailGrp ) );
      h->addWidget( new QRadioButton( i18n("Mail to "), mailGrp ) );
    }
    {
      // User Select
      usrCmb = new UserComboBox( mailGrp );
      usrCmb->setUser(UserComboBox::All);
      h->addWidget( usrCmb );
      connect( usrCmb, SIGNAL( activated( const QString& ) ), this,
                        SLOT( slotUserChanged( const QString& ) ) );
    }
    connect( mailGrp, SIGNAL( clicked( int ) ), this,
                        SLOT( slotMailButtons( int ) ) );
  }
  {
    // Variable Group Box
    varGrp = new CButtonGroup( i18n("Variable"), this );
    v->addWidget( varGrp );
    QVBoxLayout* v1 = new QVBoxLayout( varGrp->layout() );
    {
      QHBoxLayout* h1 = new QHBoxLayout( v1, 5 );
      {
        // Variable List View
        varLvw = new VarListView( varGrp );
        varLvw->setVar( ev->Vars );
        connect( varLvw, SIGNAL( clicked( QListViewItem* ) ),
             this, SLOT( slotVarChanged( QListViewItem* ) ) );
        h1->addWidget( varLvw );
      }
      // Variable Edit
      QVBoxLayout* v2 = new QVBoxLayout( h1, 5 );
      {
        // Name
        v2->addWidget( new QLabel( i18n("Name"), varGrp ) );
        namLed = new QLineEdit( varGrp );
        v2->addWidget( namLed );
        connect( namLed, SIGNAL( textChanged(const QString&) ),
                 this, SLOT ( slotNameChanged(const QString&) ) );
      }
      {
        // Value
        v2->addWidget( new QLabel( i18n("Value"), varGrp ) );
        valLed = new QLineEdit( varGrp );
        v2->addWidget( valLed );
        connect( valLed, SIGNAL( textChanged(const QString&) ),
                 this, SLOT ( slotValueChanged(const QString&) ) );
      }
      {
        // Comment
        v2->addWidget( new QLabel( i18n("Comment"), varGrp ) );
        cmtTed = new QTextEdit( varGrp );
        v2->addWidget( cmtTed );
        connect( cmtTed, SIGNAL( textChanged() ),
                 this, SLOT ( slotCommentChanged() ) );
      }
      QHBoxLayout* h2 = new QHBoxLayout( v2, 5 );
      {
        // Modify Button
        h2->addWidget( new QPushButton( i18n("Modify"), varGrp ) );
        h2->addWidget( new QPushButton( i18n("Create"), varGrp ) );
        h2->addWidget( new QPushButton( i18n("Delete"), varGrp ) );
      }
    }
    connect( varGrp, SIGNAL( clicked( int ) ), this, SLOT( slotVarButtons( int ) ) );
  }
  {
    //
    // Ok/Cancel Button
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    h->addStretch( 1 );
    {
      // OK
      okBtn = new QPushButton( i18n("&OK"), this );
      h->addWidget( okBtn );
      okBtn->setDefault( true );
      okBtn->setEnabled( false );
      connect( okBtn, SIGNAL( clicked() ), this, SLOT( accept() ) );
    }
    {
      // Cancel
      QPushButton *canbutton = new QPushButton( i18n("&Cancel"), this );
      h->addWidget( canbutton );
      connect( canbutton, SIGNAL( clicked() ), this, SLOT( reject() ) );
    }
  }                                                    
  
  setCaption( i18n("Variable Setting") );

  //
  // Initialze Mail Group Box
  if ( mflg ) setMailFromVar();

  setButtons();

}

//
// Initialize Mail Group Box from Varialble
void VarDlg::setMailFromVar()
{

  // Get Varialble "MAILTO"
  VarListViewItem *v = (VarListViewItem*)varLvw->findItem( "MAILTO", 0 );
  if ( v ){
    if ( v->value == "" || v->value == "\"\"" ){
      // Mail Off
      usrCmb->setEnabled( false );
      ((QRadioButton*)mailGrp->find(0))->setChecked( true );
    }else{
      // Mail To User
      usrCmb->setEnabled( true );
      ((QRadioButton*)mailGrp->find(2))->setChecked( true );
      usrCmb->setCurrentText( v->value );
    }
  }else{
    // Mail To 'crontab' Owner
    usrCmb->setEnabled( false );
    ((QRadioButton*)mailGrp->find(1))->setChecked( true );
  }

  return;
}

//
// Change Button Access
void VarDlg::setButtons()
{

  bool m=true, c=true, d=true;

  if ( namLed->text() == "" || valLed->text() == "" ){
    // Variable Name Not Set
    m=false;
    c=false;
    d=false;
  }else{
    VarListViewItem *v = (VarListViewItem*)varLvw->findItem( namLed->text(), 0 );
    if ( v ){
      // Current Variable Name Exist
      if ( v->value == valLed->text() && v->cmnt == cmtTed->text() ){
        // Variable Value and Comment Changed
        m=false;
      }
      c=false;
    }else{
      // New Variable Name
      m=false;
      d=false;
    }
  }
  ((QPushButton*)varGrp->find(0))->setEnabled( m );   // Modify
  ((QPushButton*)varGrp->find(1))->setEnabled( c );   // Create
  ((QPushButton*)varGrp->find(2))->setEnabled( d );   // Delete

}

//
//---SLOTS-------------------------------------------------------------------

//
// Header Changed
void VarDlg::slotHeaderChanged()
{
  okBtn->setEnabled( true );
}
//
// Mail Mode Radio Button
void VarDlg::slotMailButtons( int i )
{
  VarListViewItem *vl = (VarListViewItem*)varLvw->findItem( "MAILTO", 0 );

  if ( i == 0 ){
    // Mail Off
    if ( vl == NULL ){
      vl = new VarListViewItem( varLvw, "MAILTO", "\"\"", "" );
    }else{
      vl->value = "";
      vl->setText( 1, "" );
    }
  }else if ( i == 1 ){
    // Mail To 'crontab' Owner
    if ( vl != NULL ){
      vl->setSelected( false );
      varLvw->removeItem( vl );
    }
  }else if ( i == 2 ){
    // Mail To Selected User
    QString u = usrCmb->currentText();
    if ( vl == NULL ){
      vl = new VarListViewItem( varLvw, "MAILTO", u, "" );
    }else{
      vl->value = u;
      vl->setText( 1, u );
    }
  }
  setButtons();
  okBtn->setEnabled( true );
  //
  // Initialze Mail Group Box
  if ( mailFlag ) setMailFromVar();
}

//
// Mail Send User Changed
void VarDlg::slotUserChanged( const QString& str )
{
  VarListViewItem *vl = (VarListViewItem*)varLvw->findItem( "MAILTO", 0 );
  if ( vl != NULL ){
    vl->value = str;
    vl->setText( 1, str );
  }
  setButtons();
  okBtn->setEnabled( true );
}

//
// Varialble List View Item Selected
void VarDlg::slotVarChanged(QListViewItem *i)
{

  if ( i == NULL ) return;

  // Initialize Edit 'Text Edit'
  VarListViewItem *v = (VarListViewItem*)i;
  namLed->setText( v->name );
  valLed->setText( v->value );
  cmtTed->setText( v->cmnt );
  setButtons();
}

//
// Variable Name Changed
void VarDlg::slotNameChanged(const QString&)
{
  setButtons();
}

//
// Variable Value Changed
void VarDlg::slotValueChanged(const QString&)
{
  setButtons();
}

//
// Variable Comment Changed
void VarDlg::slotCommentChanged()
{
  setButtons();
}

//
// 'Modify/Create/Delete' Button Action
void VarDlg::slotVarButtons( int i )
{

  if ( i == 0 ){
    // Modify Button
    VarListViewItem *v = (VarListViewItem*)varLvw->selectedItem();
    v->name = namLed->text();
    v->value = valLed->text();
    v->cmnt = cmtTed->text();
    v->setText( 0, namLed->text() );
    v->setText( 1, valLed->text() );
  }else if ( i == 1 ){
    // Create Button
    varLvw->setSelected(
        new VarListViewItem( varLvw, namLed->text(), valLed->text(), cmtTed->text() ), true );
  }else if ( i == 2 ){
    // Delete Button
    VarListViewItem *v = (VarListViewItem*)varLvw->selectedItem();
    varLvw->removeItem( v );
  }
  setButtons();
  okBtn->setEnabled( true );

  //
  // Initialze Mail Group Box
  if ( mailFlag ) setMailFromVar();
  
}
