/***************************************************************************
                          confDlg.h  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CONFDLG_H
#define CONFDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qtabdialog.h>
#include <qstringlist.h>

// include files for KDE
#include <kdialog.h>

// forward declaration
class Configs;
class IconPushButton;
class QCheckBox;
class QSpinBox;
class QLineEdit;
class QRadioButton;
class QTimeEdit;
class QPushButton;
class QListBox;
class QTextEdit;
class QComboBox;
class CButtonGroup;

#define CHG_CRON  0x01
#define CHG_ANAC  0x02
#define CHG_AT    0x04
#define CHG_LIST  0x08
#define CHG_ELIST 0x10
#ifndef CRON_DILLON
#define CHG_LLIST 0x20
#endif
//#define CHG_BACK  0x40
#define CHG_CLOCK 0x80


/**
  * General Option Tab
  */
class GenTab : public QWidget
{
  public:

    /** Constructor */
    GenTab( QWidget* p );
    /** Destructor */
    ~GenTab() {}

    QCheckBox*      anacCbx;    // Use 'anacron'
    QCheckBox*      atCbx;      // Use 'at'
    QSpinBox*       exeSbx;     // Execute List Max
    QCheckBox*      edayCbx;    // Use Execute Day
    QSpinBox*       edaySbx;    // Execute Max Day
    QComboBox*      backCbb;    // Background Color
    QComboBox*      clockCbb;   // Clock Image
    CButtonGroup*   pathBgr;    // Path Button Group
    QCheckBox*      soundCbx;   // Use Sound
    QSpinBox*       soundSbx;   // Play Time
    QComboBox*      soundCbb;   // Sound Name
    IconPushButton* soundBtn;   // Test Sound
    QRadioButton*   dayRdb;     // Day Mode
    QRadioButton*   hourRdb;    // Hour Mode
    QRadioButton*   minuteRdb;  // Minute Mode
    QCheckBox*      weekdayCbx; // Machine On Weekday
    QTimeEdit*      timeTme;    // Machine On Time
#ifndef CRON_DILLON
    QCheckBox*      scronCbx;   // User System 'crontab'
    QSpinBox*       logSbx;     // Log Max
    QLineEdit*      logLed;     // Log File Directory
    QCheckBox*      alogCbx;    // Automatic Log Update
#endif

};

/**
  * 'cron' Option Tab
  */
class CronTab : public QWidget
{
  public:

    /** Constructor */
    CronTab( QWidget* p );
    /** Destructor */
    ~CronTab();
  
    QCheckBox*      litCbx;     // Use Literal
    QLineEdit*      cronLed;    // 'cron' Directory
    QLineEdit*      spoolLed;   // Spool Directory
#ifndef CRON_DILLON
    QLineEdit*      allowLed;   // Allow File Path
    QLineEdit*      denyLed;    // Deny File Path
    QLineEdit*      sysLed;     // System 'crontab' File
#endif
    QRadioButton*   allRbt;     // All Users
    QRadioButton*   allowRbt;   // Allow Users
    QRadioButton*   denyRbt;    // Deny Users
    IconPushButton* usrBtn;     // Allow/Deny User Select
    QTextEdit*      headTed;    // Header Template
    QTextEdit*      cmndTed;    // Command Template
    CButtonGroup*   pathBgr;    // Path Button Group
    CButtonGroup*   usrBgr;     // User Button Group

    /** 'cron' Users List */
    QStringList*    cronUsers;
    /** 'cron' Users Type (ALL/ALLOW/DENY) */
    int             cronUser;
    bool            cronUserChg;

};

/**
  * 'anacron' Option Tab
  */
class AnacTab : public QWidget
{
  public:

    /** Constructor */
    AnacTab( QWidget* p );
    /** Destructor */
    ~AnacTab() {}

    QCheckBox*      dspexeCbx;    // Display Execute List
    QLineEdit*      sysLed;       // System 'anacrontab' File
    QLineEdit*      spoolLed;     // Spool Directory
    QTextEdit*      headTed;      // Header Template
    QTextEdit*      cmndTed;      // Command Template
    CButtonGroup*   pathBgr;      // Path Button Group

};

/**
  * 'at' Option Tab
  */
class AtTab : public QWidget
{
  public:

    /** Constructor */
    AtTab( QWidget* p );
    /** Destructor */
    ~AtTab();

    QCheckBox*      dspexeCbx;    // Display Execute List
    QLineEdit*      pathLed;      // 'at' Directory (at.allow,at.deny)
    QRadioButton*   allRbt;       // All User
    QRadioButton*   allowRbt;     // Allow User
    QRadioButton*   denyRbt;      // Deny User
    IconPushButton* usrBtn;       // User Select Button
    QSpinBox*       delaySpb;     // New Command : Dely Time
    QRadioButton*   monRbt;       // New Command : Mail ON
    QRadioButton*   moffRbt;      // New Command : Mail OFF
    QTextEdit*      cmndTed;      // Command Template
    CButtonGroup*   pathBgr;      // Path Button Group
    CButtonGroup*   usrBgr;       // User Select Button Group

    /** 'at' Users List */
    QStringList*    atUsers;
    /** 'at' Users Type (ALL/ALLOW/DENY) */
    int             atUser;
    bool            atUserChg;

};

/**
  * User Setting Dialog
  */
class UserDlg : public KDialog
{
  Q_OBJECT
  public:
    /** Constructor */
    UserDlg( int flg, QStringList* ulist );
    /** Destructor */
    ~UserDlg() {}

    QListBox*     setLbx;         // Set List
    QListBox*     allLbx;         // All List
    bool          chgFlg;

  protected slots:
    /** Add Action */
    void slotAdd();
    /** Remove Action */
    void slotRemove();

};

/**
  * Option Setting Dialog
  */
class ConfDlg : public QTabDialog
{
  Q_OBJECT
  public:
    /** Constructor */
    ConfDlg();
    /** Destructor */
    ~ConfDlg() {}

    GenTab    *genTab;      // General Setting
    CronTab   *cronTab;     // 'cron' Configure Setting
    AnacTab   *anacTab;     // 'anacron' Configure Setting
    AtTab     *atTab;       // 'at' Configure Setting

    /** Change Configure */
    int       chgFlag;

    bool      atEnable;

  public slots:
    /** General Tab Path Check Button Action */
    void slotGenPathCheck( int idx );
    /** General Tab Use Day Check Button Action */
    void slotGenUseDay( bool b );
    /** General Tab Sound Test */
    void slotSoundTest();
    /** 'cron' Tab User Access Buttons */
    void slotCronUserAccess( int idx );
    /** 'cron' Path Check Buttons */
    void slotCronPathCheck( int idx );
    /** 'anacron' Path Check Buttons */
    void slotAnacPathCheck( int idx );
    /** 'at' Tab User Access Buttons */
    void slotAtUserAccess( int idx );
    /** 'at' Path Check Buttons */
    void slotAtPathCheck( int idx );
    /** Apply Action */
    void slotApply();
    

};

#endif // CONFDLG_H
