/***************************************************************************
                          clockView.cpp  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>
#include <stdlib.h>      // for abs()

// include files for Qt
#include <qstring.h>
#include <qdatetime.h>
#include <qlistview.h>
#include <qlist.h>
#include <qfile.h>
#include <qframe.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qpicture.h>

// include files for KDE

// application specific includes
#include "system.h"
#include "option.h"
#include "docTables.h"
#include "clockView.h"

extern QDateTime* g_CurTime;
extern Option*    g_Option;
extern int        g_SecsNext;

#define ARCSZ ( 0.28 )
#define ARCST_YEAR ( 0.25 - ( ARCSZ / 2 ) )
#define ARCEN_YEAR ( 0.25 + ( ARCSZ / 2 ) )
#define ARCST_WEEK ( 0.75 - ( ARCSZ / 2 ) )
#define ARCEN_WEEK ( 0.75 + ( ARCSZ / 2 ) )

const char* WEEK_STR[] = { "M o", "T u", "W e", "T h", "F r", "S a", "S u" };

//const int Cir5 = 76;
static ClockConfig *CC;


/////////////////////////////////////////////////////////////////////////////
// ClockConfig - Clock Initialize Data

//
// Constructor
ClockConfig::ClockConfig()
{

  int c_h, c_s, c_v;
  QColor color;

  // Get Clock Configure Text
  QString s = CconfFile( g_Option->clockImage ).readText();

  // Extract Each Line
  QStringList sl = QStringList::split( '\n', s, false );
  for ( QStringList::Iterator i=sl.begin(); i != sl.end(); i++ ){
    s = *i;
    // Get Name
    QString name = s.section( '=', 0, 0 );
    name.stripWhiteSpace();
    // Get Value
    QString value = s.section ( '=', 1 );
    value.stripWhiteSpace();

    if ( name == "Background" ){
      // Background Image
      backImage = CimagFile( value );
    }else if ( name == "ClockImage" ){
      // Clock Image
      clockImage = CimagFile( value );
      // Clock Size
      clockSize = clockImage.size();
    }else if ( name == "Font" ){
      // Font
      font.fromString( value );
    }else if ( name == "FrameColor" ){
      // Frame Color
      color = getColor( value );
      forgFramePen = QPen( color, 1, QPen::SolidLine );
      color.hsv( &c_h, &c_s, &c_v );
      color.setHsv( c_h, c_s/3, c_v );      
      backFramePen = QPen( color, 1, QPen::SolidLine );
    }else if ( name == "FrameBack" ){
      // Frame Back Grond Color
      backFramePen = QPen( getColor( value ), 1, QPen::SolidLine );      
    }else if ( name == "TextColor" ){
      // Text Forground Pen
      color = getColor( value );
      forgTextPen = QPen( color, 1, QPen::SolidLine );
      color.hsv( &c_h, &c_s, &c_v );
      color.setHsv( c_h, c_s/3, c_v );
      backTextPen = QPen( color, 1, QPen::SolidLine );
    }else if ( name == "TextBack" ){
      // Text Background Pen
      backTextPen = QPen( getColor( value ), 1, QPen::SolidLine );
    }else if ( name == "SelectColor" ){
      // Text Forground Pen
      color = getColor( value );
      forgStextPen = QPen( color, 1, QPen::SolidLine );
      color.hsv( &c_h, &c_s, &c_v );
      color.setHsv( c_h, c_s/3, c_v );
      backStextPen = QPen( color, 1, QPen::SolidLine );
    }else if ( name == "SelectBack" ){
      // Text Background Pen
      backStextPen = QPen( getColor( value ), 1, QPen::SolidLine );
    }else if ( name == "HandPen" ){
      // Hand Frame Pen
      handPen = QPen( getColor( value ), 1, QPen::SolidLine );
    }else if ( name == "HandBrush" ){
      // Hand Brush
      handBrush = QBrush( getColor( value ), QBrush::SolidPattern );
    }else if ( name == "NextPen" ){
      // Next Hand Frame Pen
      nextHandPen = QPen( getColor( value ), 1, QPen::SolidLine );
    }else if ( name == "NextBrush" ){
      // Next Hand Brush
      nextHandBrush = QBrush( getColor( value ), QBrush::SolidPattern );
    }else if ( name == "SecondPen" ){
      // Second Pen
      secPen = QPen( getColor( value ), 2, QPen::SolidLine );
//      secBrush = QBrush( getColor( value ), QBrush::SolidPattern );
    }else if ( name == "IntvalPen" ){
      // Interval Circle Pen
      ivalPen = QPen( getColor( value ), 2, QPen::SolidLine );
    }else if ( name == "ShortHandSpace" ){
      // Short Hand Space
      shortHandSpace = value.toInt();
    }else if ( name == "MiddleHandSpace" ){
      // Middle Hand Space
      middleHandSpace = value.toInt();
    }else if ( name == "FrameSpace" ){
      frameSpace = value.toInt();
    }
  }

}

//
// Get Color from String
QColor ClockConfig::getColor( const QString& c )
{
  int r = QString(c.section( ',', 0, 0 )).toInt();
  int g = QString(c.section( ',', 1, 1 )).toInt();
  int b = QString(c.section( ',', 2, 2 )).toInt();
  return QColor( r, g, b );
}


/////////////////////////////////////////////////////////////////////////////
// PaintClock - Clock Painter Class

//
// Constructor
PaintClock::PaintClock( const QPaintDevice *pd, const QPoint& cent )
 : QPainter(pd), center( cent )
{
  translate( double(cent.x()), double(cent.y()) );
  cir1 = CC->clockSize.width() / 2 - CC->frameSpace;
  cir2 = cir1 - CC->shortHandSpace;
  cir3 = cir2 - CC->shortHandSpace;
  cir4 = cir3 - CC->shortHandSpace;
  cir5 = cir4 - CC->shortHandSpace;
}

//
// Draw Circle
void PaintClock::drwCircle( int l /* Radius */)
{
  setPen( penBack );
  drawEllipse( -(l)+1, -(l)+1, l*2, l*2 );
  setPen( penForg );
  drawEllipse( -(l), -(l), l*2, l*2 );

}

//
// Draw Circle Line
void PaintClock::drwCirLine( double a, int len, int siz )
{
  setPen( penBack );
  drawLine( getCirX(a,len)+1, getCirY(a,len)+1, getCirX(a,len+siz)+1, getCirY(a,len+siz)+1 );
  setPen( penForg );
  drawLine( getCirX(a,len), getCirY(a,len), getCirX(a,len+siz), getCirY(a,len+siz) );
}

//
// Draw Pie
void PaintClock::drwPie( double d1, double d2, int len )
{
  setPen( penBack );
  drawPie( -(len)+1, -(len)+1, len*2, len*2, int( 5760.0 * (1.25-d1) ), int(5760.0 * d2) );
  setPen( penForg );
  drawPie( -(len), -(len), len*2, len*2, int( 5760.0 * (1.25-d1) ), int(5760.0 * d2) );
}

//
// Draw Arc
void PaintClock::drwArc( double d1, double d2, int len )
{
  setPen( penBack );
  drawArc( -(len)+1, -(len)+1, len*2, len*2, int( 5760.0 * (1.25-d1) ), int(5760.0 * d2) );
  setPen( penForg );
  drawArc( -(len), -(len), len*2, len*2, int( 5760.0 * (1.25-d1) ), int(5760.0 * d2) );
}

//
// Draw Interval (Arc)
void PaintClock::drwIval( double d1, double d2, int len )
{
  setRasterOp( XorROP );
  setPen( CC->ivalPen );
  drawArc( -(len), -(len), len*2, len*2, int( 5760.0 * (1.25-d1) ), int(5760.0 * d2) );
  setRasterOp( CopyROP );
}
//
// Draw Number (0-60)
void PaintClock::drwNum( int l, double d, int num )
{
  setPen( penBack );
  QRect  r1( getCirX( d, l )-12, getCirY( d, l )-9, 26, 22 );
  drawText( r1, AlignCenter, QString().setNum(num) );
  setPen( penForg );
  QRect  r2( getCirX( d, l )-13, getCirY( d, l )-10, 26, 22 );
  drawText( r2, AlignCenter, QString().setNum(num) );
}

//
// Initialize Clock Frame
void PaintClock::initFrame()
{


  // flg : 1=backgound,0=forground
  penForg = CC->forgFramePen;
  penBack = CC->backFramePen;
  setFont( CC->font );
  resetXForm();
  translate( double(center.x()), double(center.y()) );

  // Frame ( out of month )
//  drwCircle( cir1 );
  // Frame ( month )
  drwCircle( cir2 );
  // Frame ( day )
  drwCircle( cir3 );
  // Frame ( hour )
  drwCircle( cir4 );

  int i;
  double d;

  // Frame ( month )
  for( d=0.0, i=1; i<=12; i++, d+=(1.0/12.0) ){
    drwCirLine(d,cir2, CC->shortHandSpace );
  }

  // Frame ( day )
  for( d=0.0, i=1; i<=31; i++, d+=(1.0/31.0) ){
    drwCirLine(d,cir3, CC->shortHandSpace );
  }

  // Frame ( hour )
  for( d=0.0, i=0; i<=23; i++, d+=(1.0/24.0) ){
    drwCirLine(d,cir4, CC->shortHandSpace );
  }

  // Frame Clock
  for( d=0.0; d < 1.0; d+=(1.0/60.0) ){
    drwCirLine(d,cir4-6, 6 );
  }

  for( d=0.0; d < 1.0; d+=(1.0/12.0) ){
    drwCirLine(d,cir4-10, 10 );
  }



  // Year
  resetXForm();
  translate( double(center.x()-68 ), double( center.y() ) );
  drwPie( ARCEN_YEAR, ARCSZ, CC->middleHandSpace );
  for( d=ARCST_YEAR, i=0; i < 2; i++, d+=(ARCSZ/2.0) ){
    drwCirLine(d,CC->middleHandSpace-12, 12 );
  }

  // Week
  resetXForm();
  translate( double(center.x()+68 ), double( center.y() ) );
  drwPie(ARCEN_WEEK, ARCSZ, CC->middleHandSpace );
  for( d=ARCST_WEEK, i=0; i < 7; d+=(ARCSZ/7.0), i++ ){
    drwCirLine(d,CC->middleHandSpace-12, 12 );
  }

  resetXForm();
  translate( double(center.x()), double(center.y()) );
  penBack = CC->backTextPen;
  penForg = CC->forgTextPen;
  for( i=0; i < 31; i++ ){
    drwDayN( i+1 );
    if ( i <= 23 ) {
      drwHourN( i );
      if ( i < 12 ){
        drwMonthN( i+1 );
        if ( i < 7 ) drwWeekN( i );
      }
    }
  }
  int y = g_CurTime->date().year();
  drwYearN( y, y );
  drwYearN( y, y+1 );

  resetXForm();
  translate( double(center.x()), double(center.y()) );

}

//
// Draw Year Hand
void PaintClock::drawYear( int ycur /* Current Year */, int ynext /* Next Year */, bool yflg )
{
  double dd;
  /* Set Coordinate */
  resetXForm();
  translate( double(center.x()-68 ), double( center.y() ) );

  /* Current Year Hand Positon */
  double dcur = ARCST_YEAR + ((ARCSZ / (2.0*365.0)) * double(ycur));
  
  QPointArray a;
  if ( yflg ){
    int yn;
    if ( ynext < 0 ) yn = 0;
    else if ( ynext > (365*2) ) yn = 365*2;
    else yn = ynext;
    /* Next Year Hand Positon */
    double dnext = ARCST_YEAR + ((ARCSZ / (2.0*365.0)) * double(yn));
    /* Arc to Next Year */
    drwIval( dnext, dnext-dcur, CC->middleHandSpace-3 );
    if ( ynext >= 0 && ynext <= (365*2)){
      /* Draw Next Year Hand */
      int p1 = CC->middleHandSpace - 1;
      int p2 = CC->middleHandSpace - CC->shortHandSpace + CC->shortHandSpace / 2;
      dd = 0.45 / p2;
      setPen( CC->nextHandPen );
      setBrush( CC->nextHandBrush );
      a.setPoints( 3, getCirX(dnext,p1), getCirY(dnext,p1),
                    getCirX(dnext+dd, p2), getCirY(dnext+dd, p2 ),
                    getCirX(dnext-dd, p2 ), getCirY(dnext-dd, p2 ) );
      drawPolygon( a );
    }
  }   
    /* Draw Current Year Hand */
  setPen( CC->handPen );
  setBrush( CC->handBrush );
  dd = 0.04 ;
  int p1 = CC->middleHandSpace - 2;
  a.setPoints( 4, getCirX(dcur,p1), getCirY(dcur,p1),
                  getCirX(dcur+dd, 10 ), getCirY(dcur+dd, 10 ),
                  0, 0,
                  getCirX(dcur-dd, 10 ), getCirY(dcur-dd, 10 ) );
  drawPolygon( a );

  /* Reset Coordinate */
  resetXForm();
  translate( double( center.x() ), double( center.y() ) );

}

//
// Draw Week Hand
void PaintClock::drawWeek( int cur, int next, int sec )
{
  double dd;
  QPointArray a;

  /* Set Coordinate */
  resetXForm();
  translate( double(center.x()+68 ), double( center.y() ) );


  /* Current Week Hand Positon */
  double dcur = ARCEN_WEEK - ((ARCSZ / (7.0*24.0)) * double(cur));

  if ( next >= 0 ){
    /* Next Week Hand Positon */
    double dnext = ARCEN_WEEK - ((ARCSZ / (7.0*24.0)) * double(next));

    /* Arc to Next Week */
    if ( abs(sec) <= ( 60 * 60 * 24 * 7 )  && sec != 0 ){
      double dn;
      double dc;
      if ( sec > 0 && cur > next ){
        drwIval( ARCEN_WEEK, ARCEN_WEEK-dnext, CC->middleHandSpace-3 );
        dc = dcur;
        dn = ARCST_WEEK;
      }else if ( sec < 0 && cur < next ){
        drwIval( ARCST_WEEK, ARCST_WEEK-dnext, CC->middleHandSpace-3 );
        dc = dcur;
        dn = ARCEN_WEEK;
      }else{
        dc = dcur;
        dn = dnext;
      }
      drwIval( dc, dc-dn, CC->middleHandSpace-3 );
    }
    /* Draw Next Week Hand */
    setPen( CC->nextHandPen );
    setBrush( CC->nextHandBrush );
    int p1 = CC->middleHandSpace - 1;
    int p2 = CC->middleHandSpace - CC->shortHandSpace + CC->shortHandSpace / 2;
    dd = 0.45 / p2;
    a.setPoints( 3, getCirX(dnext,p1), getCirY(dnext,p1),
                    getCirX(dnext+dd, p2 ), getCirY(dnext+dd, p2 ),
                    getCirX(dnext-dd, p2 ), getCirY(dnext-dd, p2 ) );
    drawPolygon( a );
  }

  /* Draw Current Week Hand */
  setPen( CC->handPen );
  setBrush( CC->handBrush );
  dd = 0.04 ;
  int p1 = CC->middleHandSpace - 2;
  a.setPoints( 4, getCirX(dcur,p1), getCirY(dcur,p1),
                  getCirX(dcur+dd, 10 ), getCirY(dcur+dd, 10 ),
                  0, 0,
                  getCirX(dcur-dd, 10 ), getCirY(dcur-dd, 10 ) );
  drawPolygon( a );

  /* Reset Coordinate */
  resetXForm();
  translate( double( center.x() ), double( center.y() ) );
}

//
// Draw Month Hand
void PaintClock::drawMonth( int cur, int next, int sec, int days )
{
  double dd;
  QPointArray a;

  /* Current Month Hand Positon */
  double dcur = (1.0 / 365.0) * double(cur);

  if ( next >= 0 ){

    /* Arc to Next Week */
    if ( abs(sec) <= ( 60 * 60 * 24 * (days+1) ) && sec != 0 ){
      drwIval( dcur, -(( 1.0 / (365.0 * 24.0 * 60.0 * 60.0) ) * double( sec )), cir1-2 );
    }

    /* Next Month Hand Positon */
    double dnext = (1.0 / 365.0) * double(next);

    /* Draw Next Month Hand */
    setPen( CC->nextHandPen );
    setBrush( CC->nextHandBrush );
    int cir = cir2 + CC->shortHandSpace / 3;
    dd = 0.45 / cir;
    a.setPoints( 3, getCirX(dnext,cir1-1), getCirY(dnext,cir1-1),
                    getCirX(dnext+dd, cir ), getCirY(dnext+dd, cir ),
                    getCirX(dnext-dd, cir ), getCirY(dnext-dd, cir ) );
    drawPolygon( a );  
  }

  /* Draw Current Month Hand */
  setPen( CC->handPen );
  setBrush( CC->handBrush );
  dd = 0.45 / cir2;
  a.setPoints( 3, getCirX(dcur,cir1-1), getCirY(dcur,cir1-1),
                    getCirX(dcur+dd, cir2 ), getCirY(dcur+dd, cir2 ),
                    getCirX(dcur-dd, cir2 ), getCirY(dcur-dd, cir2 ) );
  drawPolygon( a );

}


//
// Draw Day Hand
void PaintClock::drawDay( int cur, int next, int sec, int days )
{
  double dd;
  QPointArray a;

  /* Current Day Hand Positon */
  double dcur = (1.0 / (31.0*24.0*60.0*60.0)) * double(cur);

  if ( next >= 0 ){
    /* Next Day Hand Positon */
    double dnext = (1.0 / (31.0*24.0*60.0*60.0)) * double(next);

    /* Arc to Next Day */
//    if ( abs(sec) <= ( 60 * 60 * 24 * (days+1) ) && sec != 0 ){
    if ( abs(sec) <= ( 60 * 60 * 24 * days ) && sec != 0 ){
      double dx;
      if ( cur == next ){
        dx = 1.0;
      }else{
        dx = dcur-dnext;
        if ( sec > 0 ){
          if ( dcur > dnext ) dx = -1.0 + dx;
        }else{
          if( dcur < dnext ) dx = 1.0 + dx;
        }
      }
      drwIval( dcur, dx, cir2-2 );
    }

    /* Draw Next Day Hand */
    setPen( CC->nextHandPen );
    setBrush( CC->nextHandBrush );
    int cir = cir3 + CC->shortHandSpace / 3;
    dd = 0.45 / cir;
    a.setPoints( 3, getCirX(dnext,cir2-2), getCirY(dnext,cir2-2),
                    getCirX(dnext+dd, cir ), getCirY(dnext+dd, cir ),
                   getCirX(dnext-dd, cir ), getCirY(dnext-dd, cir ) );
    drawPolygon( a );
  }

  /* Draw Current Day Hand */
  setPen( CC->handPen );
  setBrush( CC->handBrush );
  dd = 0.45 / cir3;
  a.setPoints( 3, getCirX(dcur,cir2-2), getCirY(dcur,cir2-2),
                  getCirX(dcur+dd, cir3 ), getCirY(dcur+dd, cir3 ),
                  getCirX(dcur-dd, cir3 ), getCirY(dcur-dd, cir3 ) );
  drawPolygon( a );

}

//
// Draw Hour Hand
void PaintClock::drawHour( int cur, int next, int sec )
{

  double dd;
  QPointArray a;

  /* Current Hour Hand(short) Positon */
  double dcur = (1.0 / (24.0*60.0*60.0)) * double(cur);

  if ( next >= 0 ){

    /* Arc to Next Hour */
    if ( abs(sec) <= ( 60 * 60 * 24 ) && sec != 0  ){
      drwIval( dcur, -(1.0/(60.0*60.0*24.0) * double(sec)), cir3-2 );
    }

    /* Next Hour Hand(short) Positon */
    double dnext = (1.0 / (24.0*60.0*60.0)) * double(next);

    /* Draw Current Hour Hand(short) */
    setPen( CC->nextHandPen );
    setBrush( CC->nextHandBrush );
    int cir = cir4 + CC->shortHandSpace / 3;
    dd = 0.45 / cir;
    a.setPoints( 3, getCirX(dnext,cir3-2), getCirY(dnext,cir3-2),
                    getCirX(dnext+dd, cir ), getCirY(dnext+dd, cir ),
                    getCirX(dnext-dd, cir ), getCirY(dnext-dd, cir ) );
    drawPolygon( a );
  }

  /* Draw Current Hour Hand(short) */
  setPen( CC->handPen );
  setBrush( CC->handBrush );
  dd = 0.45 / cir4;
  a.setPoints( 3, getCirX(dcur,cir3-2), getCirY(dcur,cir3-2),
                    getCirX(dcur+dd, cir4 ), getCirY(dcur+dd, cir4 ),
                    getCirX(dcur-dd, cir4 ), getCirY(dcur-dd, cir4 ) );
  drawPolygon( a );

  /* Draw Current Hour Hand(long) */
  dcur = (1.0 / (12.0*60.0*60.0)) * double(cur);
  a.setPoints( 4, getCirX(dcur,-15), getCirY(dcur,-15),
                    getCirX(dcur+0.07, 60/7 ), getCirY(dcur+0.07, 60/7 ),
                    getCirX(dcur, 60 ), getCirY(dcur, 60 ),
                    getCirX(dcur-0.07, 60/7 ), getCirY(dcur-0.07, 60/7 ) );
  drawPolygon(  a );

}

//
// Draw Minute Hand
void PaintClock::drawMin( int cur, int next, int sec )
{
  QPointArray a;

  /* Current Minute Hand Positon */
  double dcur = (1.0 / (60.0*60.0)) * double(cur);

  if ( next >= 0 ){

    /* Arc to Next Minute */
    if ( abs(sec) <= ( 60 * 60 )  && sec != 0 ){ 
      drwIval( dcur, -(1.0/(60.0*60.0) * double(sec)), cir4-2 );
    }
    
    /* Next Minute Hand Positon */
    double dnext = (1.0 / (60.0*60.0)) * double(next);

    /* Draw Next Minute Hand */
    setPen( CC->nextHandPen );
    setBrush( CC->nextHandBrush );
    int cir = cir5 + CC->shortHandSpace / 3;
    double dd = 0.45 / cir;
    a.setPoints( 3, getCirX(dnext,cir4-1), getCirY(dnext,cir4-1),
                    getCirX(dnext+dd, cir ), getCirY(dnext+dd, cir ),
                    getCirX(dnext-dd, cir ), getCirY(dnext-dd, cir ) );
    drawPolygon( a );
  }

  /* Draw Current Minute Hand */
  setPen( CC->handPen );
  setBrush( CC->handBrush );
  a.setPoints( 4, getCirX(dcur,-20), getCirY(dcur,-20),
                  getCirX(dcur+0.05, (cir4-4)/7 ), getCirY(dcur+0.05, (cir4-4)/7 ),
                  getCirX(dcur, cir4-4 ), getCirY(dcur, cir4-4 ),
                  getCirX(dcur-0.05, (cir4-4)/7 ), getCirY(dcur-0.05, (cir4-4)/7 ) );
  drawPolygon(  a );
}

//
// Draw Second Hand
void PaintClock::drawSec( int sec, int n )
{

//cout << "PaintClock::drawSec SEC=" << n << endl;
  /* Arc to Execute Second */
  if ( n >= 0 && n <= 60 ){
    drwIval( 0.0, (1.0 / 60.0) * double(n), cir4-11 );
  }

  /* Draw Current Second Hand */
  double d = (1.0/60.0)*double(sec);
  setRasterOp( XorROP );
  setPen( CC->secPen );
  drawLine( getCirX(d,-15), getCirY(d,-15), getCirX(d,cir4-7), getCirY(d,cir4-7) );
//  drawLine( getCirX(d,7), getCirY(d,7), getCirX(d,cir4-7), getCirY(d,cir4-7) );
//  drawEllipse( -6, -6, 12, 12 );

//  setPen( CC->secPen );
//  setPen( QPen::NoPen );
//  setBrush( CC->secBrush );
//  QPointArray a;
//  a.setPoints( 4, getCirX(d,-15), getCirY(d,-15),
//                  getCirX(d+0.05, (cir4-7)/8 ), getCirY(d+0.05, (cir4-7)/8 ),
//                  getCirX(d, cir4-7 ), getCirY(d, cir4-7 ),
//                  getCirX(d-0.05, (cir4-7)/8 ), getCirY(d-0.05, (cir4-7)/8 ) );
//  drawPolygon( a );
//  drawLine( getCirX(d,-15), getCirY(d,-15), getCirX(d,cir4-7), getCirY(d,cir4-7) );
}

//
// Draw Year Number
void PaintClock::drwYearN( int s, int n )     // Year
{
  int p = n - s;
  if ( p >= 0 && p < 2 ){
    resetXForm();
    translate( double(center.x()-68 ), double( center.y() ) );
    drwNum( CC->middleHandSpace-18, ARCST_YEAR+(ARCSZ/2.0)*p+(ARCSZ/4.0), n );
    resetXForm();
    translate( double(center.x() ), double( center.y() ) );
  }
}

//
// Draw Week Number
void PaintClock::drwWeekN( int n )     // Week
{
  resetXForm();
  translate( double(center.x()+68+1 ), double( center.y()+1 ) );
  rotate( 37.0 - (14.0*n) );
  setPen( this->penBack );
  drawText( -(CC->middleHandSpace-6), 0, (const char*)WEEK_STR[n] );
  resetXForm();
  translate( double(center.x()+68 ), double( center.y() ) );
  rotate( 37.0 - (14.0*n) );
  setPen( this->penForg );
  drawText( -(CC->middleHandSpace-6), 0, (const char*)WEEK_STR[n] );
  resetXForm();
  translate( double(center.x() ), double( center.y() ) );
}
//
// Draw Munth Number
void PaintClock::drwMonthN( int n )    // Month
{
  drwNum( cir2+CC->shortHandSpace/2, ((1.0/12.0)*(n-1) )+(1.0/24.0), n );
}

// Draw Day Number
void PaintClock::drwDayN( int n )      // Day
{
  drwNum( cir3+CC->shortHandSpace/2, ((1.0/31.0)*(n-1) )+(1.0/62.0), n );
}

//
// Draw Hour Number
void PaintClock::drwHourN( int n )     // Hour
{
  drwNum( cir4+CC->shortHandSpace/2, ((1.0/24.0)*n )+(1.0/48.0), n );
}

//
// Draw Minutes Number
void PaintClock::drwMinN( int n )      // Minute
{
  drwNum( cir5+CC->shortHandSpace/2-5, ((1.0/60.0)*n )+(1.0/180.0), n );
}


/////////////////////////////////////////////////////////////////////////////////////////////////////
// ClockView - Crock Display Class

//
// Constructor
ClockView::ClockView( QWidget *p) : QFrame(p)
{

  setFrameShape( QFrame::StyledPanel );
  setFrameShadow( QFrame::Sunken );
//  setSizePolicy( QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum,
//                 7, 0,
//        sizePolicy().hasHeightForWidth() ) );
//  setSizePolicy( QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum,
//                 7, 0 ) );
//  setMinimumSize( QSize( 300, 300 ) );
//  setMinimumHeight( 300 );
  setFixedHeight( 300 );
  setMaximumWidth( 450 );

  // Start Year
  startYear = g_CurTime->date().year();
  pixFrame = NULL;
  pixCron = NULL;
  nextTime = NULL;
  cronBit = NULL;
  setBackgroundMode( NoBackground );

  // Initialize Frame
  CC = NULL;
  iniFrame( false );

  repaint( false );

}

//
// Initialize Frame Pixmap
void ClockView::iniFrame( bool cini )
{

  // Initialize Clock Config Data
  if ( cini && CC ) {
    delete CC;
    CC = NULL;
  }
  if ( !CC ) CC = new ClockConfig();
  
  // Create Frame Pixmap
  if ( pixFrame ) delete pixFrame;
  pixFrame = new QPixmap( size() );

  // Create Clock Pixmap
  if ( pixCron ) delete pixCron;
  pixCron = new QPixmap( size() );

  // Initialize Frame
  int w = width()/2;
  int h = height()/2;
  PaintClock pa( pixFrame, QPoint(w,h) );

  // Draw BackGround
  QBrush br;
  br.setPixmap( CC->backImage );
  pa.fillRect( -(w), -(h), width(), height(), br );

  // Draw Clock Image
  w = w - (width()-CC->clockSize.width())/2-1;
  h = h - (height()-CC->clockSize.width())/2-1;
  pa.drawPixmap( -(w), -(h), CC->clockImage );

  // Draw Frame
  pa.initFrame( );

  PrevSec = -1;
}

//
// Initialize Next Time (cron)
void ClockView::iniClock( CronTbl* c, QDateTime* t )
{
  if ( ! cronBit ) cronBit = new CronBit();
  cronBit->fromString( c->Time );

  iniClock( t, cronBit );

}

//
// Initialize Next Time (anacron)
void ClockView::iniClock( AnacTbl*, QDateTime* t )
{
  if ( cronBit ) delete cronBit;
  cronBit = NULL;

  iniClock( t );
}

//
// Initialize Clock Current and Next Hand
void ClockView::iniClock( QDateTime* t, CronBit* cr )
{
  nextTime = t;

  PaintClock pa( pixCron, QPoint(width()/2,height()/2) );

  // Draw Frame Image
  pa.drawPixmap( -(width()/2), -(height()/2), *pixFrame );



  // Current Hand Data
  int m_c = g_CurTime->time().minute() * 60 + g_CurTime->time().second();
  int h = g_CurTime->time().hour();
  int h_c = h * 60 * 60 + m_c;
  int d_c = (g_CurTime->date().day()-1) * 24 * 60 * 60 + h_c;
  int w_c = (g_CurTime->date().dayOfWeek()-1)*24 + h;
  int M_c = g_CurTime->date().dayOfYear()-1;
  int y_c = ( g_CurTime->date().year() - startYear ) * 365 + M_c;  
  // Next Hand Data
  int m_n,h_n,d_n,w_n,M_n,y_n,sec;
  m_n = h_n = d_n = w_n = M_n = y_n = sec = -1;
  int mdays, ydays;
  bool yflg = false;
  mdays=ydays=-1;
  sec = g_SecsNext;
  if ( t ){
    yflg = true;
    if ( sec > 0 ) {
      mdays = g_CurTime->date().daysInMonth();
      ydays = g_CurTime->date().daysInYear();
    } else {
      mdays = t->date().daysInMonth();
      ydays = t->date().daysInYear();
    }
    m_n = t->time().minute() * 60 + t->time().second();
    h = t->time().hour();
    h_n = h * 60 * 60 + m_n;
    d_n = (t->date().day()-1) * 24 * 60 * 60 + h_n;
    w_n = (t->date().dayOfWeek()-1)*24 + h;
    M_n = t->date().dayOfYear()-1;
    y_n = ( t->date().year() - startYear ) * 365 + M_n;
    pa.penBack = CC->backStextPen;
    pa.penForg = CC->forgStextPen;
    pa.setFont( CC->font );
    if ( cr == NULL ){
      pa.drwYearN( startYear, t->date().year() );    // Year
      pa.drwWeekN( t->date().dayOfWeek()-1 );    // Week
      pa.drwMonthN( t->date().month() );    // Month
      pa.drwDayN( t->date().day() );      // Day
      pa.drwHourN( h );       // Hour
      pa.drwMinN( t->time().minute() );        // Minute
      if ( cronBit ) delete cronBit;
      cronBit = NULL;
    }else{
      // Year
      pa.drwYearN( startYear, startYear );
      pa.drwYearN( startYear, startYear+1 );
      int i;
      // Week
      bool wflg = cr->Day.isFill(true) && cr->Week.isFill(false);
      for( i=0; i<7; i++ ){
        int w = i-1; if ( w  < 0 ) w = 6;
        if ( wflg || cr->Week.bTest(i) ) pa.drwWeekN( w );
      }
      // Minutes
      for( i=0; i<60; i++ ){
        if ( cr->Min.bTest(i) ) pa.drwMinN( i );
      }
      // Hour
      for( i=0; i<24; i++ ){
        if ( cr->Hour.bTest(i) ) pa.drwHourN( i );
      }
      // Month
      for( i=0; i<12; i++ ){
        if ( cr->Month.bTest(i) ) pa.drwMonthN( i+1 );
      }
      // Day
      for( i=0; i<31; i++ ){
        if ( cr->Day.bTest(i) ) pa.drwDayN( i+1 );
      }
    }
  }

  // Draw Hands
  pa.drawYear( y_c, y_n, yflg );
  pa.drawMonth( M_c, M_n, sec, ydays );
  pa.drawWeek( w_c, w_n, sec );
  pa.drawDay( d_c, d_n, sec, mdays );
  pa.drawHour( h_c, h_n, sec );
  pa.drawMin( m_c, m_n, sec );

  repaint( false  );

}

//
// Event ( Paint )
void ClockView::paintEvent( QPaintEvent *e )
{

  QFrame::paintEvent( e );
  PaintClock pa( this, QPoint(width()/2,height()/2) );

  // Draw Clock Image
  pa.drawPixmap( -(width()/2)+1, -(height()/2)+1, *pixCron, 1, 1, size().width()-2, 298 );

  // Draw Second
  pa.drawSec( g_CurTime->time().second(), g_SecsNext );
  PrevSec = g_CurTime->time().second();

}


//
// Event ( Resize )
void ClockView::resizeEvent( QResizeEvent *e )
{

  QFrame::resizeEvent( e );

  // Initialize Frame Image
  iniFrame( false );
  // Initialize Clock Image
  iniClock( nextTime, cronBit );

}

//
// Draw Current Data
void ClockView::drawTime()
{

  // Second
  int sec = g_CurTime->time().second();

  // Draw Clock Image - Every 5 Minutes
  if ( sec != 0 && ( (sec % 5 ) == 0 || ( nextTime && abs(g_SecsNext) < 60 ) ) ){
    iniClock( nextTime, cronBit );
    return;
  }

  // Draw Secend
  PaintClock pa( this, QPoint(width()/2,height()/2) );
  if ( PrevSec != -1 ){
    // Erase Previous Second
    pa.drawSec( PrevSec, -1 );
  }
  
  pa.drawSec( sec, -1 );
  PrevSec = sec;

}
