/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKVIEW_H
#define KKVIEW_H

#include <qptrlist.h>
#include <qscrollview.h>

class KKWidget;
class KKDoc;

typedef QPtrList<KKWidget> KKWidgetList;

class KKView : public QScrollView
{
	Q_OBJECT
public:
	KKView( QWidget *parent = 0, bool readonly = false, const char *name = 0 );
	~KKView();
	void setDocument( KKDoc* doc );
	void preview( const QString &filename );

signals:
	void zoomupEnabledChanged( bool );
	void zoomdownEnabledChanged( bool );
	void popup( const QPoint&, bool );

public slots:
	void zoomIn();
	void zoomOut();
	void insert();

protected:
	void wheelEvent( QWheelEvent* e );

private slots:
	void documentChanged();
	void setLayout();

private:
	double zoom();
	void setZoom( int z );
	int m_zoom;
	bool m_readonly;
	QWidget* wgtMain;
	KKWidgetList m_canvas;
	KKDoc* m_doc;
};

#endif //KKVIEW_H
