/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kfontdialog.h>

#include "kkpropertyitemtextfont.h"

KKPropertyItemTextFont::KKPropertyItemTextFont( KKPropertyItemBase* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	m_font = NULL;
	hbox = new QHBox( viewport() );
	chkEnabled = new QCheckBox( "", hbox );
	chkEnabled->setFixedSize( 16, 16 );

	btnFont = new KPushButton( hbox );
	connect( btnFont, SIGNAL( clicked() ), this, SLOT( selectFont() ) );
	connect( chkEnabled, SIGNAL( toggled( bool ) ), btnFont, SLOT( setEnabled( bool ) ) );
	setVisible( false );
}

KKPropertyItemTextFont::~KKPropertyItemTextFont()
{
}

void KKPropertyItemTextFont::start()
{
	KKPropertyItemBase::start();
/*	QFont f;
	f.fromString( text( 2 ) );
	int result = KFontDialog::getFont( f, false, btnFont );
	if ( result == KDialog::Accepted )
	{
		btnFont->setFont( f );
		btnFont->setText( f.family() );
	}*/
	chkEnabled->setChecked( !text( 1 ).isEmpty() );
	btnFont->setEnabled( chkEnabled->isChecked() );
	if( chkEnabled->isChecked() )
	{
		btnFont->setFont( m_font ? QFont( *m_font ) : document()->font() );
		btnFont->setText( m_font ? btnFont->font().family() : "" );
	}
	btnFont->setFocus();
}

void KKPropertyItemTextFont::accept()
{
	if( !btnFont->isVisible() ) return;
	if( chkEnabled->isChecked() )
	{
		document()->setTextFont( btnFont->font() );
	}
	KKPropertyItemBase::accept();
}

void KKPropertyItemTextFont::reset()
{
	KKPropertyItemBase::reset();
	QFont* font = NULL;
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	if( selectedItems.isEmpty() )
	{
		setVisible( false );
		return;
	}
	else
	{
		setVisible( ((KKItem*)selectedItems.first())->parent() != NULL );
	}
	font = new QFont( ((KKItem*)selectedItems.first())->textFont() );
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		if( font != NULL && *font != item->textFont() )
		{
			if( font ) delete font;
			font = NULL;
			break;
		}
	}
	chkEnabled->setChecked( font );
	if( document()->selectedItems().count() > 1 ) chkEnabled->show(); else chkEnabled->hide();
	setText( 1, font ? font->family() : "" );
	setText( 2, font ? font->toString() : "" );
	if( m_font ) delete m_font;
	m_font = font ? new QFont( *font ) : NULL;
	if( font ) delete font;
}

void KKPropertyItemTextFont::selectFont()
{
	QFont f = btnFont->font();
	f.fromString( text( 2 ) );
	int result = KFontDialog::getFont( f, false, btnFont );
	if ( result == KDialog::Accepted )
	{
		btnFont->setFont( f );
		btnFont->setText( f.family() );
		accept();
	}
	else
	{
		abort();
	}
}
