/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKPROPERTYITEMTEXTALIGN_H
#define KKPROPERTYITEMTEXTALIGN_H

#include <qgrid.h>
#include <qcheckbox.h>

#include <kpushbutton.h>

#include "kkpropertyitembase.h"

class TextAlignEditor;

class KKPropertyItemTextAlign : public KKPropertyItemBase
{
	Q_OBJECT
public:
	KKPropertyItemTextAlign( KKPropertyItemBase* parent, const QString &text );

	~KKPropertyItemTextAlign();

public slots:
	void reset();
	void start();
	void accept();

private:
	TextAlignEditor* editor;
};

class TextAlignEditor : public QWidget
{
	Q_OBJECT
public:
	TextAlignEditor( QWidget* parent );
	~TextAlignEditor();
	int align();
	void setAlign( int align );

signals:
	void accept();
	void abort();

private slots:
	void alignChanged( bool );

private:
	KPushButton* btnAlign[3][3];
	int m_x, m_y;
};
#endif //KKPROPERTYITEMTEXTALIGN_H
