/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qvbox.h>
#include <qimage.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qtooltip.h>

#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>

#include "kkpropertyitemimage.h"

// #define IMAGEGALLERY
#ifdef IMAGEGALLERY
#include "kkimagegallery/kkimagegallery.h"
#endif

KKPropertyItemImage::KKPropertyItemImage( KKProperty* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	( new QWidget( viewport() ) )->setBackgroundMode( NoBackground );
	QVBox* vbox = new QVBox( viewport() );
	vbox->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Expanding );
	vbox->setBackgroundMode( NoBackground );
	hboxBase = new QHBox( vbox );
	btnRequest = new KPushButton( SmallIcon( "folder_open" ), "", hboxBase );
	btnRequest->setFixedSize( baseSize(), baseSize() );
	QToolTip::add( btnRequest, i18n("Open New Image File") );
	connect( btnRequest, SIGNAL( clicked() ), this, SLOT( imageRequest() ) );

#ifdef IMAGEGALLERY
	btnGallery = new KPushButton( SmallIcon( "view_icon" ), "", hboxBase );
	btnGallery->setFixedSize( baseSize(), baseSize() );
	QToolTip::add( btnGallery, i18n("Open Image Gallery") );
	connect( btnGallery, SIGNAL( clicked() ), this, SLOT( imageGallery() ) );
#endif

	btnErase = new KPushButton( SmallIcon( "eraser" ), "", hboxBase );
	btnErase->setFixedSize( baseSize(), baseSize() );
	QToolTip::add( btnErase, i18n("Erase Image") );
	connect( btnErase, SIGNAL( clicked() ), this, SLOT( imageErase() ) );

#ifdef IMAGEGALLERY
	hboxBase->setFixedSize( baseSize() * 3, baseSize() );
#else
	hboxBase->setFixedSize( baseSize() * 2, baseSize() );
#endif
	( new QWidget( vbox ) )->setBackgroundMode( NoBackground );

	setVisible( false );
}

KKPropertyItemImage::~KKPropertyItemImage()
{
}

void KKPropertyItemImage::start()
{
	KKPropertyItemBase::start();
	if( pixmap( 1 ) )
	{
//		wgtImage->setPaletteBackgroundPixmap( *pixmap( 1 ) );
	}
	else
	{
//		wgtImage->setPaletteBackgroundColor( white );
	}
	btnRequest->setFocus();
}

void KKPropertyItemImage::accept()
{
	if( !viewport()->isVisible() ) return;
	document()->setImage( pixmap( 2 ) ? (*pixmap( 2 )).convertToImage() : QImage() );
	KKPropertyItemBase::accept();
}

void KKPropertyItemImage::reset()
{
	KKPropertyItemBase::reset();
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	setVisible( !selectedItems.isEmpty() );
	if( selectedItems.isEmpty() ) return;
	QPixmap pix;
	QImage image = ((KKItem*)selectedItems.first())->image();
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		if( image.isNull() != item->image().isNull() && image != item->image() )
		{
			image = QImage();
			break;
		}
	}
	pix.convertFromImage( image );
	setPixmap( 2, pix );
	if( !image.isNull() )
	{
		pix.convertFromImage( image.smoothScale( 80, 80, QImage::ScaleMin ) );
	}
	setPixmap( 1, pix );
}

void KKPropertyItemImage::imageRequest()
{
	KURL url = KFileDialog::getOpenFileName( QString::null, i18n( "image/png image/jpeg image/gif image/tiff image/x-bmp|All Supported File" ) );
	if( url.isEmpty() )
	{
		abort();
		return;
	}
	setPixmap( 2, QPixmap( url.path() ) );
	accept();
}

void KKPropertyItemImage::imageGallery()
{
#ifdef IMAGEGALLERY
	KKImageGallery dlg( KKImageGallery::Select, viewport() );
	dlg.exec();
	if( dlg.result() )
	{
		setPixmap( 2, dlg.pixmap() );
		accept();
	}
	else
	{
		abort();
	}
#endif
}

void KKPropertyItemImage::imageErase()
{
	setPixmap( 2, QPixmap() );
	accept();
}
