/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qheader.h>
#include <qlayout.h>

#include <klocale.h>
#include <kdebug.h>
#include <kiconloader.h>

#include "kkdoc.h"
#include "kkpropertyitembase.h"

KKPropertyItemBase::KKPropertyItemBase( KKProperty* parent, const QString &text )
	: QObject( parent ), KListViewItem( parent, text )
{
	m_height = 1;
	setupWidget( (KKProperty*)parent );
}

KKPropertyItemBase::KKPropertyItemBase( KKPropertyItemBase* parent, const QString &text )
	: QObject( parent ), KListViewItem( parent, text )
{
	m_height = 1;
	setupWidget( (KKProperty*)parent->listView() );
}

void KKPropertyItemBase::setupWidget( KKProperty* parent )
{
	m_baseSize = height();
	m_parent = parent;
	m_viewport = new QWidget( parent->viewport() );
	m_viewport->setBackgroundMode( NoBackground );
	(new QHBoxLayout( m_viewport ))->setAutoAdd( true );
	btnCancel = new KPushButton( SmallIcon( "cancel" ), "", parent->viewport() );
	btnCancel->setFixedSize( height(), height() );
	connect( btnCancel, SIGNAL( clicked() ), this, SLOT( abort() ) );
	m_viewport->hide();
	btnCancel->hide();
}


KKPropertyItemBase::~KKPropertyItemBase()
{
}

void KKPropertyItemBase::setSelected( bool selected )
{
	if( !selected )
	{
		accept();
	}
	QListViewItem::setSelected( selected );
}

void KKPropertyItemBase::start()
{
	QListView* parent = listView();
	int x, y, width, height;
	QRect rect( parent->itemRect( this ) );
	x = rect.x() - 1;
	y = rect.y() - 1;
	width = parent->columnWidth( 1 ) + 2;
	height = rect.height() * m_height + 2;

	if( height > parent->visibleHeight() )
	{
		y = 0;
		height = parent->visibleHeight();
	}
	while( y + height > parent->visibleHeight() )
	{
			y -= 2;
	}

	int pos = parent->header()->mapToIndex(1);
	for( int index = 0; index < pos; index++ )
	{
		x += parent->columnWidth( parent->header()->mapToSection( index ) );
	}
	m_viewport->setGeometry( x, y, width - btnCancel->width(), height );
	btnCancel->move( x + m_viewport->width(), rect.y() );
	m_viewport->show();
	btnCancel->show();
}

void KKPropertyItemBase::accept()
{
	m_viewport->hide();
	btnCancel->hide();
}

void KKPropertyItemBase::abort()
{
	if( btnCancel->isVisible() ) btnCancel->hide();
	if( m_viewport->isVisible() ) m_viewport->hide();
}

void KKPropertyItemBase::reset()
{
	if( btnCancel->isVisible() ) abort();
}
