/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKIMAGEGALLERY_H
#define KKIMAGEGALLERY_H

#include <qpixmap.h>

#include <kdialogbase.h>
#include <kpushbutton.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <klistview.h>

class KKImageGallery : public KDialogBase
{
	Q_OBJECT
public:
	enum Type
	{
		Normal,	// called from ToolMenu [Close]
		Select,	// called from Toolbar or PropertyEditor [Ok][Cancel]
	};
	KKImageGallery( Type type, QWidget* parent = 0, const char* name = 0 );
	~KKImageGallery();
	QPixmap pixmap();

private slots:
	void slotAdd();
	void slotRemove();

private:
	void setupWidgets();
	void readData();
	bool saveData();
	KPushButton* btnLocal;
	KPushButton* btnWebSite;
	KListView* lvwFavorite;

protected slots:
};

#endif //KKIMAGEGALLERY_H
