/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qdir.h>
#include <qfile.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qvbox.h>

#include <kmessagebox.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kdebug.h>
#include <kstdguiitem.h>
#include <kconfig.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <kurl.h>

#include "kkimagegallery.h"
// #include "dlgimagegalleryadd.h"

KKImageGallery::KKImageGallery( Type type, QWidget *parent, const char *name)
	: KDialogBase(
		parent, name, true, i18n( "Image Gallery" )
		, User1|User2|(( type == Normal ) ? Close : Ok|Cancel )
		, (( type == Normal ) ? Close : Ok )
		, true
		, KGuiItem( i18n( "Remove" ), "eraser" )
		, KGuiItem( i18n( "Add" ), "filefind" )
		)
{
	setupWidgets();
	KConfig *conf = KGlobal::config();
	conf->setGroup("KKImageGallery");
	resize( configDialogSize( "KKImageGallery" ) );
	readData();
}

KKImageGallery::~KKImageGallery()
{
	saveData();
	KConfig *conf = KGlobal::config();
	conf->setGroup("KKImageGallery");
// 	conf->writeEntry( "Split", splBase->sizes() );
	saveDialogSize( "KKImageGallery" );
}

void KKImageGallery::setupWidgets()
{
	QHBox* hbxBase = new QHBox( this );

	QVBox* vbox = new QVBox( hbxBase );

	QLabel* lbl = new QLabel( i18n( "Type" ), vbox );
	lbl->setFrameStyle( QFrame::Panel | QFrame::Raised );
	lbl->setPaletteBackgroundColor( gray );
	lbl->setAlignment( AlignCenter );
	lbl->setSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::Fixed );

	btnLocal = new KPushButton( DesktopIcon( "folder" ), i18n( "Local folder" ), vbox );

	btnWebSite = new KPushButton( DesktopIcon( "network" ), i18n( "Web site" ), vbox );

	lbl = new QLabel( i18n( "Favorite" ), vbox );
	lbl->setFrameStyle( QFrame::Panel | QFrame::Raised );
	lbl->setPaletteBackgroundColor( gray );
	lbl->setAlignment( AlignCenter );
	lbl->setSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::Fixed );

	lvwFavorite = new KListView( vbox );

	(new QWidget( hbxBase ))->setSizePolicy( QSizePolicy::Preferred, QSizePolicy::Preferred );
	setMainWidget( hbxBase );
}

void KKImageGallery::readData()
{
/*	QString datafile = locateLocal( "data", KGlobal::instance()->instanceName() + "/kkgallery.xml" );
	QDomDocument doc( "kkgallery" );
	QFile file( datafile );
	if( file.open( IO_ReadOnly ) )
	{
		if( !doc.setContent( &file ) )
		{
			return;
		}
		file.close();
	}
	else
	{
		return;
	}

	for( QDomNode n = doc.documentElement().lastChild(); !n.isNull(); n = n.previousSibling() )
	{
		QDomElement e = n.toElement();

		QListViewItem* item = new QListViewItem( lvwLeft, e.attribute( "title" ), e.attribute( "url" ) );
		item->setOpen( e.hasAttribute( "isopen" ) );
		item->setPixmap( 0, SmallIcon( "folder" ) );
		item->setRenameEnabled( 0, true );
		item->setText( 1, "/usr/kde/3.3/share/icons/default.kde/" );	// for testing
		makeFolderTree( item );
	}
	if( lvwLeft->firstChild() )
	{
		lvwLeft->setSelected( lvwLeft->firstChild(), true );
	}*/
}

bool KKImageGallery::saveData()
{
// 	QString datafile = locateLocal( "data", KGlobal::instance()->instanceName() + "/kkgallery.xml" );
// 	QDomDocument doc( "kkgallery" );
// 	doc.appendChild( doc.createProcessingInstruction( "xml", "version=\"1.0\" encoding=\"UTF-8\"" ) );
// 	QDomElement root = doc.createElement( "kkgallery" );
// 	root.setAttribute( "version", "0.1" );
//
// 	QListViewItem* item = lvwLeft->firstChild();
// 	while( item )
// 	{
// 		QDomElement e = doc.createElement( "item" );
// 		e.setAttribute( "title", item->text( 0 ) );
// 		if( item->isOpen() ) e.setAttribute( "isopen", "1" );
// 		e.setAttribute( "url", item->text( 1 ) );
// 		root.appendChild( e );
// 		item = item->nextSibling();
// 	}
// 	doc.appendChild( root );
// 	QFile file( datafile );
// 	if ( !file.open( IO_WriteOnly ) ){
// 		KMessageBox::sorry( this, i18n("Can not open file") );
// 		return false;
// 	}
// 	QTextStream str( &file );
// 	str << doc;
// 	file.close();
	return true;
}

// void KKImageGallery::selectionChanged( QListViewItem* item )
// {
// 	if( !item ) return;
// 	QDir dir( item->text( 1 ) );
// 	QStringList icons;
// 	const QStringList files = dir.entryList( QDir::Files | QDir::Readable );
// 	for( QStringList::ConstIterator it = files.begin(); it != files.end(); ++it )
// 	{
// 		icons.append(  item->text( 1 ) +  *it );
// 	}
// 	icoCanvas->loadFiles( icons );
// }

// void KKImageGallery::makeFolderTree( QListViewItem* parent )
// {
// 	QDir dir( parent->text( 1 ) );
//
// 	const QStringList list = dir.entryList( QDir::Dirs | QDir::Readable );
// 	for ( QStringList::ConstIterator it = list.begin(); it != list.end(); ++it )
// 	{
// 		if( *it == "." || *it == ".." ) continue;
// 		QListViewItem* item = new QListViewItem( parent, *it, dir.absPath() + "/" + *it + "/" );
// 		item->setOpen( true );
// 		item->setPixmap( 0, SmallIcon( "folder" ) );
// 		makeFolderTree( item );
// 	}
// }

QPixmap KKImageGallery::pixmap()
{
	QPixmap pix;
	return pix;
}

void KKImageGallery::slotAdd()
{
/*	KKImageGalleryAdd dlg( this );
	dlg.exec();
	if( !dlg.result() ) return;

	QListViewItem* item = new QListViewItem( lvwLeft, dlg.title(), dlg.path() );
	item->setOpen( true );
	item->setPixmap( 0, SmallIcon( "folder" ) );
	item->setRenameEnabled( 0, true );
	lvwLeft->setSelected( item, true );
	makeFolderTree( item );*/
}

void KKImageGallery::slotRemove()
{
}
