/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKCMDNAME_H
#define KKCMDNAME_H

#include "kkcmdbase.h"

class KKCmdName : public KKCmdBase
{
public:
	KKCmdName( KKDoc* doc );

protected:
	QString propertyName();
	void execute( KKItem* item );
	void unexecute( KKItem* item );
	void begin( KKItem* item );
	bool end( KKItem* item );

private:
	QMap<KKItem*,QString> m_before;
	QMap<KKItem*,QString> m_after;
};

#endif //KKCMDNAME_H
