/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qimage.h>

#include "kkcmdimage.h"

KKCmdImage::KKCmdImage( KKDoc* doc )
	: KKCmdBase( doc )
{
	connect( this, SIGNAL( executed() ), doc, SIGNAL( imageChanged() ) );
	connect( this, SIGNAL( unexecuted() ), doc, SIGNAL( imageChanged() ) );
}

void KKCmdImage::execute( KKItem* item )
{
	item->setImage( m_after[item] );
}

void KKCmdImage::unexecute( KKItem* item )
{
	item->setImage( m_before[item] );
}

void KKCmdImage::begin( KKItem* item )
{
	m_before[item] = item->image();
}

bool KKCmdImage::end( KKItem* item )
{
	bool rtn = ( m_before[item] != item->image() );
	if( rtn )
	{
		m_after[item] = item->image();
	}
	else
	{
		m_before.remove( item );
	}
	return rtn;
}

QString KKCmdImage::propertyName()
{
	return i18n( "image" );
}
