/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KK_SETUPGROUP_DIALOG_H_
#define _KK_SETUPGROUP_DIALOG_H_

#include <kdialog.h>

class QStringList;
class QToolButton;

class KListView;

class KKSetupGroupDialog : public KDialog
{
	Q_OBJECT
public:
	KKSetupGroupDialog( QWidget *parent = 0, const char *name = 0 );
	~KKSetupGroupDialog();

	bool isModified() const { return isGroupModified; }

protected slots:
	void addNewGroup();
	void removeSelectedGroup();
	void slotOK();

protected:
	void setupWidgets();
	
	void readList();
	void saveList();
	
protected:
	QStringList mGroupList;
	
	KListView *mGroupListView;
	QToolButton *mAddButton;
	QToolButton *mRemoveButton;
	QToolButton *mOKButton;
	
	bool isGroupModified;	
};

#endif /* Not def: _KK_SETUPGROUP_DIALOG_H_ */
