/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KK_CONTACT_DATA_H_
#define _KK_CONTACT_DATA_H_

class QString;

// 2004-11-11 Kazuki Ohta <mover@hct.zaq.ne.jp>
// Experimental Format
class KKContactData {
public:
	// 2004-11-11 Kazuki Ohta <mover@hct.zaq.ne.jp>
	// The way creating ContactData object is restricted
	// to constructor. This aims to detect all the location
	// which relates to ContactData creation on compilation
	// time when format is changed
	KKContactData( const QString &pronunciation,
		       const QString &fullname,
		       const QString &namesuffix,
		       const QString &group,
		       const QString &zipcode,
		       const QString &address1,
		       const QString &address2,
		       const QString &pcemail = QString::null,
		       const QString &phonenumber = QString::null,
		       const QString &cellularphonenumber = QString::null,
		       const QString &cellularphoneemail = QString::null )
	{
		m_pronunciation = pronunciation;
		m_fullname = fullname;
		m_namesuffix = namesuffix;
		m_group = group;
		m_zipcode = zipcode;
		m_address1 = address1;
		m_address2 = address2;

		// Extra
		m_pcemail = pcemail;
		m_phonenumber = phonenumber;
		m_cellularphonenumber = cellularphonenumber;
		m_cellularphoneemail = cellularphoneemail;
	}

	QString getPronunciation() const { return m_pronunciation; }
	QString getFullname() const { return m_fullname; }
	QString getNameSuffix() const { return m_namesuffix; }
	QString getGroup() const { return m_group; }
	QString getZipCode() const { return m_zipcode; }
	QString getAddress1() const { return m_address1; }
	QString getAddress2() const { return m_address2; }

	// Extra
	QString getPCEmail() const { return m_pcemail; }
	QString getPhoneNumber() const { return m_phonenumber; }
	QString getCellularPhoneNumber() const { return m_cellularphonenumber; }
	QString getCellularPhoneEmail() const { return m_cellularphoneemail; }
	
private:
	QString m_pronunciation;
	QString m_fullname;
	QString m_namesuffix;
	QString m_group;
	QString m_zipcode;
	QString m_address1;
	QString m_address2;

	// Extra
	QString m_pcemail;
	QString m_phonenumber;
	QString m_cellularphonenumber;
	QString m_cellularphoneemail;
};


#endif /* Not def: _KK_CONTACT_DATA_H_ */
