#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include "transInfo.h"
#include "extern.h"
#include "transMgr.h"

/****************************************************************
 *
 * Declaration
 *
 ***************************************************************/
extern void parser(char query[], const int clientfd, const int lfd1, const int lfd2);

/****************************************************************
 *
 * Global variable
 *
 ***************************************************************/
/****************************************************************
 *
 * Private Function
 *
 ***************************************************************/
/****************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern PERSISTENT_OBJ *
allocPrstDlteObj(const char schemaName[], const int tplid)
{
  PERSISTENT_OBJ *p;
  
  if ((p = calloc(1, sizeof(PERSISTENT_OBJ))) == NULL) ERR;
  p->type = PERSISTENT_DELETE;
  strcpy(p->u.delete.schemaName, schemaName);
  p->u.delete.tplid = tplid;

  return p;
}

extern PERSISTENT_OBJ *
allocPrstInstObj(char *objP, const char schemaName[], const PAGEINFO pi)
{
  PERSISTENT_OBJ *p;
  
  if ((p = calloc(1, sizeof(PERSISTENT_OBJ))) == NULL) ERR;
  p->type = PERSISTENT_INSERT;
  strcpy(p->u.insert.schemaName, schemaName);
  p->u.insert.pi = pi;
  if ((p->u.insert.objP = calloc(1, pi.sizOfObj)) == NULL) ERR;
  memcpy(p->u.insert.objP, objP, pi.sizOfObj);

  return p;
}

extern PERSISTENT_OBJ *
allocPrstApndObj(const char schemaName[], const char attrName[], SDOBJ obj, const PAGEINFO pi)
{
  PERSISTENT_OBJ *p;

  if ((p = calloc(1, sizeof(PERSISTENT_OBJ))) == NULL) ERR;
  p->type = PERSISTENT_APPEND;
  strcpy(p->u.append.attrName, attrName);
  strcpy(p->u.append.schemaName, schemaName);
  p->u.append.pi = pi;
  p->u.append.obj = obj;

  return p;
}
