#include "common.h"
#include "buffsize.h"
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include "ipc.h"

typedef enum {INSERT, APPEND} TYPE;

/***************************************************************
 *
 * Declaration
 *
 ***************************************************************/
extern void sendQuery(const char query[], const int sockfd);
extern TYPE_OF_ANSWER recvTypeOfAnswer(const int sockfd);
extern ANSWER recvAnswer(const int sockfd);
extern void printResultForRelation(ANSWER answer);
extern void printResultForSchema(const int sockfd);
extern void printResultOfOperation(const TYPE_OF_ANSWER typeOfAnswer);
extern int connectKraftByClient(void);
extern int connectKraftBySensor(void);
extern void sendExitAndCloseSockfd(const int sockfd);
extern void getResultOfAdhocQuery(const int sockfd);

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static void
issueAppend(const int id, const int nbQuery)
{
  int kraftfd, i, fd;
  char query[QUERY_BUFFSIZE];

  kraftfd = connectKraftBySensor();
  for (i = 0; i < nbQuery; i ++) {
    bzero(query, QUERY_BUFFSIZE);
    sprintf(query, "append into r1.0 values (%d) where id = %d", i, id);
    //S(query);
    sendQuery(query, kraftfd);
    getResultOfAdhocQuery(kraftfd);
  }
  sendExitAndCloseSockfd(kraftfd);

  if ((fd = open("file", LOCK_EX|O_APPEND)) == -1) ERR;
  if (write(fd, &id, sizeof(int)) == -1) ERR;
  if (close(fd) == -1) ERR;

  exit(0);
}

static void
exeAppend(const int nbQuery, const int nbCli)
{
  int i, pid, fd, n;
  
  if ((fd = open("file", O_CREAT|O_TRUNC, 0644)) == -1) ERR;
  if (close(fd) == -1) ERR;
  
  for (i = 0; i < nbCli; i ++) {
    if ((pid = fork()) == 0) 
      issueAppend(i, nbQuery);
  }

  if ((fd = open("file", O_RDONLY)) == -1) ERR;  
  while (1) {
    flock(fd, LOCK_SH);
    n = lseek(fd, 0, SEEK_END);
    flock(fd, LOCK_UN);
    if (n == nbCli * (int)sizeof(int)) {
      if (close(fd) == -1) ERR;
      break;
    }
    sleep(1);
  }
}

static void
issueInsert(const int nbQuery, const int startid)
{
  int sockfd, i;
  char query[QUERY_BUFFSIZE];

  sockfd = connectKraftByClient();
  for (i = 0; i < nbQuery; i ++) {
    bzero(query, QUERY_BUFFSIZE);
    //sprintf(query, "insert into r10 values (%d, null, null, null, null, null, null, null, null, null, null)", i + startid);
    sprintf(query, "insert into r1 values (%d, null)", i + startid);
    sendQuery(query, sockfd);
    getResultOfAdhocQuery(sockfd);
    //sleep(1);
  }
  sendExitAndCloseSockfd(sockfd);
}

static void
exeInsert(const int nbQuery, const int startid)
{
  issueInsert(nbQuery, startid);
}

static TYPE
getType(char c)
{
  TYPE type;

  if (c == 'i') 
    type = INSERT;
  else if (c == 'a') 
    type = APPEND;
  else
    ERR;

  return type;
}

static void
printUsage(void)
{
  printf("Usage:\n");
  printf("\tINSERT: program i nbQuery startid\n");
  printf("\tAPPEND: program a nbQuery nbCli\n");
  exit(1);
}

static void
chkInput(const int argc)
{
  if (argc != 4)
    printUsage();
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int 
main(const int argc, char *argv[])
{
  int nbCli, nbQuery, startid;
  TYPE type;
  
  chkInput(argc);
  type = getType(argv[1][0]);
  nbQuery = atoi(argv[2]);
  
  switch(type) {
  case INSERT:
    startid = atoi(argv[3]);
    exeInsert(nbQuery, startid);
    break;
  case APPEND:
    nbCli = atoi(argv[3]);
    exeAppend(nbQuery, nbCli);
    break;
  }
    
  return 0;
}
