/*
 * Defines
 */
#ifndef BUFFSIZE 
#include "buffsize.h"
#endif
typedef enum {LESS, LESS_EQUAL, GREATER, GREATER_EQUAL, EQUAL, NOT_EQUAL} OPERAND;
typedef enum {BINARY, SIMSEQ, LATEST, RANGE} TYPE_OF_CONDITION;
typedef enum {TIME_RANGE, VALUE_RANGE} TYPE_OF_RANGE;
typedef enum {AND, OR} ANDOR;
typedef enum {EUCLID, WARPING, LCSS} METRIC;
typedef enum {ASC_ORDER_TYPE, DESC_ORDER_TYPE, NO_ORDER_TYPE} ORDER_TYPE;
typedef enum {SIMSEQ_INTERNAL, SIMSEQ_LATEST, SIMSEQ_EXTERNAL} SIMSEQ_TYPE;
typedef enum {SIMSEQ_EXTERNAL_NUMBER_INTEGER, SIMSEQ_EXTERNAL_NUMBER_FLOAT} SIMSEQ_EXTERNAL_NUMBER_TYPE;
typedef enum {SIMSEQ_LATEST_NUMBER_INTEGER, SIMSEQ_LATEST_NUMBER_FLOAT} SIMSEQ_LATEST_NUMBER_TYPE;
typedef enum {SIMSEQ_LATEST_UNIT_ITEM, SIMSEQ_LATEST_UNIT_SEC, SIMSEQ_LATEST_UNIT_MILISEC} SIMSEQ_LATEST_UNIT_TYPE;
typedef enum {PAST, BOTH, FUTURE} DIRECTION_OF_VIEW_FOR_RANGE_CODITION;
typedef struct _SELECT_ATTR {
  BOOLEAN occurParseError;
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
  struct _SELECT_ATTR *next;
} SELECT_ATTR;
typedef struct _BINARY_CONDITION {
  /* left */
  char leftText[BUFFSIZE];
  int attridOfLeft;
  BOOLEAN leftTextExistsInSchema;
  /* right */
  char rightText[BUFFSIZE];
  int attridOfRight;
  BOOLEAN rightTextExistsInSchema;
  /* others */
  OPERAND operand;
} BINARY_CONDITION;
typedef struct _SIMSEQ_CONDITION_INTERNAL {
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
  int attrid;
  int tupleid;
  struct timeval startArrival;
  struct timeval endArrival;
} SIMSEQ_CONDITION_INTERNAL;
typedef union _SIMSEQ_EXTERNAL_NUMBER_VALUE {
  double floatValue;
  int integerValue;
} SIMSEQ_EXTERNAL_NUMBER_VALUE;
typedef union _SIMSEQ_LATEST_NUMBER_VALUE {
  double floatValue;
  int integerValue;
} SIMSEQ_LATEST_NUMBER_VALUE;
typedef struct _SIMSEQ_CONDITION_EXTERNAL {
  int numOfValue;
  SIMSEQ_EXTERNAL_NUMBER_TYPE simseqExternalNumberType;
  SIMSEQ_EXTERNAL_NUMBER_VALUE *value;
} SIMSEQ_CONDITION_EXTERNAL;
typedef struct _SIMSEQ_CONDITION_LATEST {
  int tupleid;
  int numOfItem;
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
  struct timeval timespan;
  SIMSEQ_LATEST_NUMBER_TYPE numberType;
  SIMSEQ_LATEST_NUMBER_VALUE u;
  SIMSEQ_LATEST_UNIT_TYPE unitType;
} SIMSEQ_CONDITION_LATEST;
typedef union _SIMSEQ_CONDITION_UNION {
  SIMSEQ_CONDITION_INTERNAL internal;  
  SIMSEQ_CONDITION_EXTERNAL external;  
  SIMSEQ_CONDITION_LATEST latest;  
} SIMSEQ_CONDITION_UNION;
typedef struct _SIMSEQ_CONDITION {
  SIMSEQ_TYPE simseqType;
  SIMSEQ_CONDITION_UNION u;
  METRIC metric;
  OPERAND operand;
  double threshold;
} SIMSEQ_CONDITION;
typedef struct _LATEST_CONDITION {
  int attrid;
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
} LATEST_CONDITION;
typedef struct _RANGE_CONDITION {
  TYPE_OF_RANGE typeOfRange;
  int attrid;
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
  OPERAND operand;
  double threshold;
  DIRECTION_OF_VIEW_FOR_RANGE_CODITION dirOfViewObj; /* Which direction would you like to see ? */
  int numOfViewObj; /* How many objects would you like to see ? */
} RANGE_CONDITION;
typedef union _LATEST_SIMSEQ_BINARY_RANGE_CONDITION {
  SIMSEQ_CONDITION simseq;
  BINARY_CONDITION binary;
  LATEST_CONDITION latest;
  RANGE_CONDITION range;
} LATEST_SIMSEQ_BINARY_RANGE_CONDITION;
typedef struct _CONDITION {
  BOOLEAN occurParseError;
  ANDOR andor;
  TYPE_OF_CONDITION typeOfCondition;
  LATEST_SIMSEQ_BINARY_RANGE_CONDITION u;
  struct _CONDITION *next;  
} CONDITION;
typedef struct _FROM_SCHEMA {
  BOOLEAN occurParseError;
  char schemaName[BUFFSIZE];
  int offset;
  struct _FROM_SCHEMA *next;
} FROM_SCHEMA;
typedef struct _SCHEMA_LIST {
  SCHEMA *pSchema;
  struct _SCHEMA_LIST *next;
} SCHEMA_LIST;
typedef struct _CONDITION_LIST {
  CONDITION headCondition;
  struct _CONDITION_LIST *next;
} CONDITION_LIST;
typedef struct _TUPLE_LIST {
  TUPLE *pTuple;
  struct _TUPLE_LIST *next;
} TUPLE_LIST;
typedef struct _ORDER_INFO {
  BOOLEAN occurParseError;
  ORDER_TYPE orderType;
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
} ORDER_INFO;
typedef struct _ANSWER {
  int numOfSensorSegmentAttr;
  int numOfAnswerTuple;
  int numOfAttr;
  int byteOfTuple;
  ATTR *attr;
  TUPLE headTuple;
  TUPLE_LIST headAndorTupleList;
  BOOLEAN occurParseError;
} ANSWER;
