#ifndef _BUFFSIZE_H
#define _BUFFSIZE_H
#include "buffsize.h"
#endif

#ifndef _PAGE_H
#define _PAGE_H
#include "page.h"
#endif

#define MIN_BTREE_FANOUT 2              /* Half of uplimit fanouts per page */
#define METASIZE 64

typedef enum {INT, DOUBLE, TEXT, SENSOR_SEGMENT_DOUBLE} ATTR_TYPE;
typedef enum {HASH_INDEX, BTREE_INDEX} INDEX_TYPE;

struct _SCHEMA;
typedef struct _PAGEINFO {
  int tupleid;             /* For FQDN */
  int attrid;              /* For FQDN */
  int numOfObj;            /* Number of objects in the page ? */
  int sizOfObj;            /* Size of objects in the page */
  int offset;              /* Page offset in data file, 4096 byte times X */  
} PAGEINFO;
typedef struct _DBPAGE {
  struct _SCHEMA *schemaP; /* Pointer to schema infomation */
  char data[PAGESIZE];     /* Data area */
  int access;              /* For LRU replacement */
  char path[BUFFSIZE];     /* Path for the data file */
  PAGEINFO pi;             /* Page information */
	pthread_rwlock_t rwlock;
} DBPAGE;
typedef struct _SDOBJ { /* Sensor Data Object */
  double value;
  char meta[METASIZE];
  struct timeval generate;
  struct timeval arrival;
} SDOBJ;
typedef struct _SENSOR {
  SDOBJ sdobj;
  struct _SENSOR *prev;
  struct _SENSOR *next;
} SENSOR;
typedef struct _SENSOR_SEGMENT {
  int attrid;
  int offset;
  int sizOfObj;
  DBPAGE *startP; /* For OBJ_IN_SENSOR_BINARY */
  DBPAGE *endP;   /* For OBJ_IN_SENSOR_BINARY */
	pthread_rwlock_t rwlock;
  SENSOR headSensor;
  SENSOR *pLastSensor;
  struct _SENSOR_SEGMENT *next;
} SENSOR_SEGMENT;
typedef struct _TUPLE {
  int offset;        /* Offset in each data file */
  BOOLEAN garbage;   /* Is this garbage tuple ? */
  BOOLEAN certified; /* This flag is used for AND/OR */
  BOOLEAN selected;  /* This flag is used for selection */
  char *obj;         /* Data Area */
  struct _TUPLE *next;
  struct _TUPLE *prev;
  pthread_rwlock_t rwlock;
} TUPLE;
typedef  struct _PAGEPTR {
  DBPAGE *startP;
  DBPAGE *endP;
} PAGEPTR;
typedef struct _ATTR {
  ATTR_TYPE attrType;
  int sizOfAttr;
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
  BOOLEAN projected;   /* For projection of quries */
  int offset;          /* For OBJ_IN_SENSOR_BINARY */
  int numOfObj;        /* For OBJ_IN_SENSOR_BINARY */
  PAGEPTR *p;          /* For append */
} ATTR;

#ifndef _TAIL_OFFSET_H
#define _TAIL_OFFSET_H
#include "tailOffset.h"
#endif

typedef struct _OFFSET {
  int offset;
  struct _OFFSET *next;
  struct _OFFSET *prev;
} OFFSET;
typedef struct _HASH_NODE {
  TUPLE *pTuple;
  struct _HASH_NODE *next;
} HASH_NODE;
typedef struct _HASH_BUCKET {
  int hashKey;
  HASH_NODE headHashNode;
  struct _HASH_BUCKET *next;
} HASH_BUCKET;
typedef int KEYTYPE;      /* Search key type */
typedef struct _BTREE_DATA {
  int key;
  int offset;
  struct _BTREE_DATA *next;
} BTREE_DATA;
typedef struct _BTREE_PAGE {       
  int n;                  /* Number of data */
  KEYTYPE key[2 * MIN_BTREE_FANOUT]; 
  union {
    int branch;           /* Internal node */
    BTREE_DATA *data;     /* Leaf node */
  } u[2 * MIN_BTREE_FANOUT + 1];
  BOOLEAN thisIsLeaf;
  int offset;
} BTREE_PAGE;        
typedef struct _INDEX {
  pthread_rwlock_t rwlock;
  char indexName[BUFFSIZE];
  INDEX_TYPE indexType;
  char attrName[BUFFSIZE];
  int primeNumber;    /* For Hash */
  int minBtreeFanout; /* Minimum fanout */
  HASH_BUCKET headHashBucket;
  BTREE_PAGE rootBtreePage;
  struct _INDEX *next;
} INDEX;
typedef struct _SCHEMA {
  char schemaName[BUFFSIZE];
  char *garbageP;
  int numOfAttr;
  int sizOfObj;
  int numOfObj;
  ATTR *attr;
  TUPLE headTuple;
  INDEX headIndex;
  DBPAGE *endP; /* For insert */
  DBPAGE *startP;   /* For select */
  pthread_rwlock_t rwlock;
  struct _SCHEMA *next;
  struct _SCHEMA *prev;
} SCHEMA;
typedef struct _SENSOR_ATTR_LIST {
  int attrid;
  char attrName[BUFFSIZE];
  struct _SENSOR_ATTR_LIST *next;
} SENSOR_ATTR_LIST;
typedef struct _SENSOR_SEGMENT_ATTR_LIST {
  int numOfSensorSegment;
  int attrid;
  char attrName[BUFFSIZE];
  struct _SENSOR_SEGMENT_ATTR_LIST *next;
} SENSOR_SEGMENT_ATTR_LIST;
