/* 
 * Includes and defines 
 */
#include "buffsize.h"
#include <sys/time.h>
#define MONITOR_DIR_NAME "/home/kawasima/kraft/etc/MONITOR"
#define DEFAULT_REST_FACTOR 100
#define MICRO_SLEEP_DURATION 10

/* 
 * Typedef structs 
 */
typedef struct _STALE_LOG {
  long long staleness;
  struct _STALE_LOG *next;
} STALE_LOG;
typedef struct _GAP_LOG {
  long long gap;
  struct _GAP_LOG *next;
} GAP_LOG;
typedef struct _MONITOR_QUERY {
  char monitorName[BUFFSIZE];
  char query[BUFFSIZE];
  struct timeval period;
  long long llPeriod;
} MONITOR_QUERY;
typedef struct _OBJECTIVE_DEADLINE {
  long long deadline;
  struct _OBJECTIVE_DEADLINE *next;
} OBJECTIVE_DEADLINE;
typedef struct _ANSWER_LIST_OBJ {
  struct _ANSWER_LIST_OBJ *next;  
  ANSWER answer;
} ANSWER_LIST_OBJ;
typedef struct _MONITOR_RUN {
  int clientfd;
  int restOfAnswerListObj;
  long long prevGap;
  long long prevExecTime;
  pthread_t pthreadid;
  pthread_mutex_t mutexForAnswerListObj;
  struct timeval duration;
  struct _MONITOR_RUN *next;
  OBJECTIVE_DEADLINE headODL;
  ANSWER_LIST_OBJ headAnswerListObj;
  ANSWER_LIST_OBJ *tailAnswerListObjP;
  MONITOR_QUERY mq;
  STALE_LOG headStaleLog;
  STALE_LOG *tailStaleLogP;
  GAP_LOG headGapLog;
  GAP_LOG *tailGapLogP;
} MONITOR_RUN;
