#include "common.h"

#ifndef _BUFFSIZE_H
#include "buffsize.h"
#define _BUFFSIZE_H
#endif

#include "libWrapper.h"
#include "port.h"

#include <sys/time.h>
#include <sys/resource.h>
#include <signal.h>

#ifndef _TRANS_INFO_H
#define _TRANS_INFO_H
#include "transInfo.h"
#endif

#ifndef _LOG_INFO_H
#define _LOG_INFO_H
#include "logInfo.h"
#endif

#ifndef _EXTERN_H
#include "extern.h"
#define _EXTERN_H
#endif

#include "sensorImageSize.h"
#include "host.h"
#include "threadInfo.h"

#ifndef _TAIL_OFFSET_H
#define _TAIL_OFFSET_H
#include "tailOffset.h"
#endif

#ifndef _MEM_SIZE_H
#define _MeM_SIZE_H
#include "memsize.h"
#endif

#define CHKPTR_SLP (1000 * 100)   /* 100 mili second */
#include "mmgr.h"

/*******************************************************
 *
 * Global variable
 *
 *******************************************************/

/*******************************************************
 *
 * Prototype
 *
 *******************************************************/
extern void difflog(struct timeval end, struct timeval begin, int tid);
extern void initMemory(int sizeOfBufferPool);
extern void recvback(const int sockfd, void *ptr, const int size, const int flag);
extern void allLogTransfer(int acptfd);
extern void initMmgr(int sizOfBuffPool);
extern void kmcpy(void *p, const unsigned long siz);
extern void kdcpy(void *p, const unsigned long siz);
extern void kgcpy(void *p, const unsigned long siz);
extern void createLogBufFileReader(void);
extern void createLogBufFileMaker(void);
extern void stopLogBufFileReader(void);
extern void stopLogBufFileMaker(void);
extern void diff(struct timeval end, struct timeval begin, int nb);

/*******************************************************
 *
 * Private Function
 *
 *******************************************************/
static void *
sighandler(int sig)
{
  fprintf(stderr, "signal obtained: %d\n", sig);

  switch(sig) {
  case SIGPIPE:    
    fprintf(stderr, "SIGPIPE\n");    
    pthread_exit(NULL);    
    break;
  case SIGINT:
    fprintf(stderr, "SIGINT\n");    
    exit(1);
    break;
  }

  return NULL;
}

static void
setLogRecordForInsert(LOG_RECORD lr, const int sockfd)
{
  char *p;

  if ((p = calloc(1, lr.u.insert.pi.sizOfObj + sizeof(LOG_RECORD))) == NULL) ERR;
  memcpy(p, &lr, sizeof(LOG_RECORD));
  recvback(sockfd, (void *)((unsigned long)p + (unsigned long)sizeof(LOG_RECORD)), lr.u.insert.pi.sizOfObj, MSG_WAITALL);
  if ((sizeof(LOG_RECORD) + lr.u.insert.pi.sizOfObj) > REMOTE_MEMORY_SIZE)
    kdcpy(p, sizeof(LOG_RECORD) + lr.u.insert.pi.sizOfObj); /* Kraft Disk Copy */
  else 
    kmcpy(p, sizeof(LOG_RECORD) + lr.u.insert.pi.sizOfObj); /* Kraft Memory Copy */
  free(p);
}

static void
initSignal(void)
{
  signal(SIGPIPE, (void(*)())sighandler);
  signal(SIGINT, (void(*)())sighandler);
}

static void
initPriority(void)
{
  if (setpriority(PRIO_PROCESS, 0, -20) == -1) 
    perror("setpriority");
}

static void *
grpLogThread(void *arg)
{
  int ack;
  int on = 1;
  int acptfd = (int)arg;
  char p[GRPCMTSIZ]; /* this must be equal to REMOTE_MEMORY_SIZE */
  struct timeval end, begin;
  
  if (setsockopt(acptfd, IPPROTO_TCP, TCP_NODELAY, &on , sizeof(on)) == -1) ERR;
  while (1) {
    if (recv(acptfd, p, GRPCMTSIZ, MSG_WAITALL) == -1) ERR2;
    //gettimeofday(&begin, NULL);
    kgcpy(p, GRPCMTSIZ);
    //gettimeofday(&end, NULL);
    //difflog(end, begin, (int)pthread_self());
    if (send(acptfd, &ack, sizeof(int), 0) == -1) ERR2;
  }
}

static void
createGrpLogThread(const int acptfd)
{
  pthread_t thread;

  if (pthread_create(&thread, NULL, (void *)grpLogThread, (void *)acptfd) != 0) ERR;
  if (pthread_detach(thread) != 0) ERR;
}

static void
initLogServer(void)
{
  initPriority();
  initSignal();
}

static void *
loggingThread(void *arg)
{
  int sockfd = (int)arg;  
  LOG_RECORD lr;
  struct timeval end, begin;

  while (1) {
    recvback(sockfd, &lr, sizeof(LOG_RECORD), MSG_WAITALL);
    switch(lr.type) {
    case PERSISTENT_APPEND:
    case PERSISTENT_DELETE: 
      //gettimeofday(&begin, NULL);
      kmcpy(&lr, sizeof(LOG_RECORD));
      //gettimeofday(&end, NULL);
      //difflog(end, begin, (int)pthread_self());
      break;
    case PERSISTENT_INSERT: 
      setLogRecordForInsert(lr, sockfd); 
      break;
    case PERSISTENT_EXIT: 
      if (close(sockfd) == -1) ERR;
      pthread_exit(NULL);
      break;
    default:
      ERR;
      break;
    }  
  }

  return NULL;
}

static void
createLoggingThread(const int dbServerFd)
{
  pthread_t thread;
  
  if (pthread_create(&thread, NULL, (void *)loggingThread, (void *)dbServerFd) != 0) ERR;
  if (pthread_detach(thread) != 0) ERR;
}

static void 
logServerLoop(void)
{
  int p2pfd; /* For P2P Communication */
  int rcvfd; /* For Recovery */
  int grpfd; /* For Group Commit */
  int acptfd, width;
  fd_set mask, readOk;
  struct timeval sleepTime;
  int on = 1;

  p2pfd = createConnection(LGSRV_P2PLG_PORT);
  rcvfd = createConnection(LGSRV_RCVRY_PORT);
  grpfd = createConnection(LGSRV_GRPLG_PORT);
  width = grpfd + 1;

  FD_ZERO(&mask);
  FD_SET(p2pfd, &mask);
  FD_SET(rcvfd, &mask);
  FD_SET(grpfd, &mask);

  sleepTime.tv_sec = 0;
  sleepTime.tv_usec = 1;
  while (1) {
    readOk = mask;
    if (select(width, (fd_set *)&readOk, NULL, NULL, &sleepTime) == -1) ERR;
    if (FD_ISSET(p2pfd, &readOk)) {
      if ((acptfd = accept(p2pfd, NULL, NULL)) == -1) ERR;
      if (setsockopt(acptfd, IPPROTO_TCP, TCP_NODELAY, &on , sizeof(on)) == -1) ERR;
      createLoggingThread(acptfd);
    }
    else if (FD_ISSET(rcvfd, &readOk)) {
      stopLogBufFileReader();
      stopLogBufFileMaker();
      if ((acptfd = accept(rcvfd, NULL, NULL)) == -1) ERR;
      allLogTransfer(acptfd); 
      createLogBufFileReader();
      createLogBufFileMaker();
    }
    else if (FD_ISSET(grpfd, &readOk)) {
      if ((acptfd = accept(grpfd, NULL, NULL)) == -1) ERR;
      createGrpLogThread(acptfd);
    }
  }
}

static void
printNowReady(void)
{
  printf("################################################################\n");
  printf("########[                                              ]########\n");
  printf("########[            LogServer is now READY            ]########\n");
  printf("########[                                              ]########\n");
  printf("################################################################\n");
}

#ifdef TIME
static void
diff(struct timeval end, struct timeval begin)
{
  long diff = (end.tv_sec - begin.tv_sec)*1000*1000 + (end.tv_usec - begin.tv_usec);
  printf("%ld micro sec\n", diff);
}
#endif

/*******************************************************
 *
 * Public Function
 *
 *******************************************************/
extern int 
main(void)
{
  initLogServer();
  printNowReady();
  logServerLoop();

  return 0;
}
