#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include "extern.h"
#include "port.h"
#include "host.h"

#ifndef _LOG_INFO_H
#define _LOG_INFO_H
#include "logInfo.h"
#endif

#ifndef _TRANS_INFO_H
#define _TRANS_INFO_H
#include "transInfo.h"
#endif

#include "printTime.h"
#include "mmgr.h"

/***********************
 *
 * Prototype Declaration
 *
 ***********************/
extern void sendback(const int sockfd, const void *ptr, const int size, const int flag);
extern void diff(struct timeval end, struct timeval begin, int nb);
extern void difflog(struct timeval end, struct timeval begin, int tid);
extern void outputLoggingTime(void);
extern void kdcpy(void *p, const unsigned long siz);
extern void kmcpy(void *p, const unsigned long siz);

/***********************
 *
 * Global variables
 *
 ***********************/
static int DiskLogfd;

/***********************
 *
 * Private Function
 *
 ***********************/
static void
setPersistentObjToLogRecord(LOG_RECORD *lrP, PERSISTENT_OBJ *poP)
{
  lrP->type = poP->type;
  switch (lrP->type) {
  case PERSISTENT_APPEND: 
    lrP->u.append = poP->u.append; 
    break;
  case PERSISTENT_INSERT: 
    lrP->u.insert = poP->u.insert; 
    break;
  case PERSISTENT_DELETE: 
    lrP->u.delete = poP->u.delete; 
    break;
  default:
    ERR;
    break;
  }
  free(poP);
}

static LOG_RECORD *
allocLogRecord(PERSISTENT_OBJ *p)
{
  LOG_RECORD *lrP;

  if ((lrP = calloc(1, sizeof(LOG_RECORD))) == NULL) ERR;
  if (gettimeofday(&(lrP->logTime), NULL) == -1) ERR;
  setPersistentObjToLogRecord(lrP, p);
  
  return lrP;
}  

static void
releaseLogRecord(LOG_RECORD *lrP)
{
  switch (lrP->type) {
  case PERSISTENT_INSERT:     
    free(lrP->u.insert.objP);
    break;
  default:
    break;
  }
  free(lrP);
}

static void
log4insert(LOG_RECORD *lrP)
{
  int siz;
  char *p;

  /* Allocate & construct space */
  siz = lrP->u.insert.pi.sizOfObj + (int)sizeof(LOG_RECORD);
  if ((p = calloc(1, siz)) == NULL) ERR;
  memcpy(p, lrP, sizeof(LOG_RECORD));
  memcpy((void *)((unsigned long)p + (unsigned long)sizeof(LOG_RECORD)), lrP->u.insert.objP, lrP->u.insert.pi.sizOfObj);

  if (siz > REMOTE_MEMORY_SIZE) 
    kdcpy(p, siz); /* Kraft Disk Copy */
  else 
    kmcpy(p, siz); /* Kraft Memory Copy */

  /* Release temporally space */
  free(p);
}

/*******************************************************
 *
 * Public Function
 *
 *******************************************************/
extern void
logInsert(PERSISTENT_OBJ *persistP)
{
  LOG_RECORD *lrP;
  struct timeval end, begin;

  /* Allocate memory for log record */
  lrP = allocLogRecord(persistP);

  switch (lrP->type) {
  case PERSISTENT_APPEND:
  case PERSISTENT_DELETE: 
    kmcpy(lrP, sizeof(LOG_RECORD));
    break;
  case PERSISTENT_INSERT: 
    log4insert(lrP); 
    break;
  default: ERR; break;
  }  

  /* Release memory for log record */
  releaseLogRecord(lrP);
}

extern void
initDiskLogfd(void)
{
  if ((DiskLogfd = open("/home/kawasima/kraft/etc/DISKLOG", O_WRONLY|O_TRUNC|O_CREAT|O_APPEND|O_FSYNC, 0644)) == -1) ERR;
}
