#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netdb.h>
#include <signal.h>
#include <readline/readline.h>
#include <readline/history.h>
#include "port.h"
#include "host.h"
#include "common.h" 
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include "buffsize.h"
#include "sensorImageSize.h"
#include "slotsize.h"
#include "ipc.h"

/****************************************************************
 *
 * Prototype
 *
 ***************************************************************/
extern int connectCli(int port, char hostname[]);
extern void releaseAnswerForClient(ANSWER answer);
extern ANSWER recvAnswer(const int sockfd);
extern void printResultForRelation(ANSWER answer);
extern void printResultForSchema(const int sockfd);
extern void printResultOfOperation(const TYPE_OF_ANSWER typeOfAnswer);
extern void getResultOfAdhocQuery(const int sockfd);
extern void sendback(const int sockfd, void *ptr, const int size, const int flag);

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static BOOLEAN
checkExit(char query[])
{
  BOOLEAN final = FALSE;
  
  if (((query[0] == 'e') && (strcmp(query, "exit") == 0)) || 
      ((query[0] == 'q') && (strcmp(query, "quit") == 0))) {
    final = TRUE;
  }

  return final;
}

static void 
sendQuery(char query[], const int sockfd)
{
  if (send(sockfd, query, QUERY_BUFFSIZE, 0) == -1) ERR;
}

static TYPE_OF_ANSWER
recvTypeOfAnswer(const int sockfd)
{
  TYPE_OF_ANSWER typeOfAnswer;

  if (recv(sockfd, &typeOfAnswer, sizeof(TYPE_OF_ANSWER), MSG_WAITALL) == -1) ERR;

  return typeOfAnswer;
}

static BOOLEAN
readOperation(char query[], FILE *fpin)
{
  char *rlquery;
  BOOLEAN shouldExit;

  bzero(query, QUERY_BUFFSIZE);
  if (fpin == NULL) {
    rlquery = readline("> ");
    add_history(rlquery);
    sprintf(query, "%s", rlquery);
    free(rlquery);
  }
  else { /* Read query from file */
    fgets(query, QUERY_BUFFSIZE, fpin);
    if (query[strlen(query)-1] == '\n') query[strlen(query)-1] = '\0';
  }
  shouldExit = checkExit(query);

  return shouldExit;
}

static void
sendExitAndCloseSockfd(const int sockfd)
{
  char query[QUERY_BUFFSIZE];

  bzero(query, QUERY_BUFFSIZE);
  strncpy(query, "exit", strlen("exit"));
  sendback(sockfd, query, QUERY_BUFFSIZE, 0);
  if (close(sockfd) == -1) ERR;
}

static BOOLEAN
isThisRunMonitor(const char query[])
{
  int qid;
  BOOLEAN thisIsRunMonitor = FALSE;

  for (qid = 0; qid < (int)(QUERY_BUFFSIZE - strlen("run")); qid ++) {
    if (strncmp(&query[qid], "run", strlen("run")) == 0) {
      thisIsRunMonitor = TRUE;
      break;
    }
  }

  return thisIsRunMonitor;
}

static void
errorAtRunMonitor(TYPE_OF_ANSWER typeOfAnswer)
{
  printf("The type is unacceptable here: %d", typeOfAnswer);
  ERR;
}

static void
execRunMonitor(const int sockfd)
{
  TYPE_OF_ANSWER typeOfAnswer;
  ANSWER answer;

  do {
    typeOfAnswer = recvTypeOfAnswer(sockfd);
    switch(typeOfAnswer) {
    case ANSWER_RELATION: 
      answer = recvAnswer(sockfd);
      printResultForRelation(answer); 
      break;
    case ANSWER_FINISH_MONITOR_RUN:       
      printf("MONITOR FINISHES\n"); 
      break;
    default: errorAtRunMonitor(typeOfAnswer);
      break;
    }
  } while (typeOfAnswer != ANSWER_FINISH_MONITOR_RUN);
}

static void
execQueryLoop(FILE *fpin)
{
  int dbServerFd;
  char query[QUERY_BUFFSIZE];
  BOOLEAN exitLoop;

  dbServerFd = connectCli(DBMS_CLIENT_PORT, DBMS_HOST);
  while ((exitLoop = readOperation(query, fpin)) == FALSE) {
    sendQuery(query, dbServerFd);
    switch(isThisRunMonitor(query)) {
    case TRUE:  
      execRunMonitor(dbServerFd);        
      break;
    case FALSE: 
      getResultOfAdhocQuery(dbServerFd); 
      break;
    }
  }
  sendExitAndCloseSockfd(dbServerFd);
}

static void
goodBye(void)
{
  printf("See you again!\n");
  fflush(stdout);
}

static FILE *
getFilePointer(char file[])
{
  FILE *fpin;

  if ((fpin = fopen(file, "r")) == NULL) ERR;
 
  return fpin;
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int
main(int argc, char *argv[])
{
  FILE *fpin;

  if (argc == 1) {
    execQueryLoop(NULL);
  }
  else {
    fpin = getFilePointer(argv[1]);
    execQueryLoop(fpin);
    if (fclose(fpin) != 0) ERR;
  }
  goodBye();

  return 0;
}
