#include "common.h"
#include "libWrapper.h"
#include "mega.h" 

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _SIMSEQ_H
#define _SIMSEQ_H
#include "simseq.h"
#endif

#ifndef _WINDOW_H
#define _WINDOW_H
#include "window.h"
#endif

/****************************************************************
 *
 * Prototype declaration
 *
 ***************************************************************/
extern double getEucDst(WINDOW *lwP, WINDOW *rwP);

/****************************************************************
 *
 * Gloval variable
 *
 ***************************************************************/
extern METAW HeadMetaw;
extern SCHEMA HeadSchema;

/****************************************************************
 *
 * Private function
 *
 ****************************************************************/
/****************************************************************
 *
 * Public function
 *
 ****************************************************************/
extern ANSWER
exesim(CONDITION *cndP, ANSWER ans)
{
  int i;
  int aid;     /* Attribute Identifier */
  int tbo;     /* Tuple byte offset */
  double dist; /* Distance between two windows */
  WINDOW *lwP, rw; 
  METAW *mP;
  SCHEMA *schP;
  SENSOR *senP;
  SENSOR_SEGMENT *sgmP;
  TUPLE *tplP;

  /* Find window from WINDOW list */
  for (mP = HeadMetaw.next; mP != NULL; mP = mP->next) {
    if (!strcmp(mP->w->name, cndP->u.sim.wn)) {
      lwP = mP->w;
      break;
    }
  }
  if (mP == NULL)
    return ans;

  /* 
   * Construct window from table data 
   */
  /* Tuple offset */
  for (schP = HeadSchema.next; schP != NULL; schP = schP->next) {
    if (!strcmp(schP->schemaName, cndP->u.sim.sn))
      break;
  }
  if (schP == NULL)
    return ans;

  for (tbo = i = 0; i < schP->numOfAttr; i++) {
    if (!strcmp(schP->attr[i].attrName, cndP->u.sim.an)) {
      aid = i;
      break;
    }
    tbo += schP->attr[i].sizOfAttr;
  }

  /* Execute Similarity Calculation */
  for (i = 0, tplP = ans.headTuple.next; tplP != NULL; tplP = tplP->next, i++) {
    sgmP = (SENSOR_SEGMENT *)&tplP->obj[tbo];
    sgmP = sgmP->next;
    
    /* Copy data from tuple to window */
    for (rw.num = 0, senP = sgmP->headSensor.next; senP != NULL; senP = senP->next, rw.num++) ;
    rw.p = calloc(rw.num, sizeof(VT));
    for (i = 0, senP = sgmP->headSensor.next; senP != NULL; senP = senP->next, i++) {
      rw.p[i].t = senP->sdobj.t;
      rw.p[i].v = senP->sdobj.v[cndP->u.sim.said]; 
    }

    /* getEucDist returns -1 when error */
    if ((dist = getEucDst(lwP, &rw)) < 0)
      continue;

    switch (cndP->u.sim.op) {
    case GREATER:
      if (dist > cndP->u.sim.th) 
        tplP->selected = TRUE;
      break;
    case GREATER_EQUAL:
      if (dist >= cndP->u.sim.th) 
        tplP->selected = TRUE;
      break;
    case LESS:
      if (dist < cndP->u.sim.th)     
        tplP->selected = TRUE;           
      break;
    case LESS_EQUAL:
      if (dist <= cndP->u.sim.th) 
        tplP->selected = TRUE;                 
      break;
    case EQUAL:
      if (dist == cndP->u.sim.th) 
        tplP->selected = TRUE;                 
      break;
    case NOT_EQUAL:
      if (dist != cndP->u.sim.th) 
        tplP->selected = TRUE;                 
      break;
    default:
      break;
    }
  }

  return ans;
}
