#include "common.h"
#include "buffsize.h"
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include "ipc.h"

/***************************************************************
 *
 * Declaration
 *
 ***************************************************************/
extern void sendQuery(const char query[], const int sockfd);
extern void printResultForRelation(ANSWER answer);
extern void printResultForSchema(const int sockfd);
extern void printResultOfOperation(const TYPE_OF_ANSWER typeOfAnswer);
extern void sendExitAndCloseSockfd(const int sockfd);
extern void getResultOfAdhocQuery(const int sockfd);
extern int connectKraftByClient(void);
extern int connectKraftBySensor(void);
extern TYPE_OF_ANSWER recvTypeOfAnswer(const int sockfd);
extern ANSWER recvAnswer(const int sockfd);

typedef struct _ARG {
  int nbQry;
  int nbTpl;
  int nbAtr;
} ARG;

/***************************************************************
 *
 * Global Variable
 *
 ***************************************************************/
static pthread_mutex_t Mutex;
static unsigned int Finished = 0;

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static void *
issueAppend(void *a)
{
  int kraftfd, i;
  char query[QUERY_BUFFSIZE];
  ARG *argP = (ARG *)a;

  kraftfd = connectKraftBySensor();
  for (i = 0; i < argP->nbQry; i ++) {
    bzero(query, QUERY_BUFFSIZE);
    sprintf(query, "append into r10.%d values (%d) where id = %d", argP->nbAtr, i, argP->nbTpl);
    sendQuery(query, kraftfd);
    getResultOfAdhocQuery(kraftfd);
  }
  sendExitAndCloseSockfd(kraftfd);

  pthread_mutex_lock(&Mutex);
  Finished ++;
  pthread_mutex_unlock(&Mutex);

  return NULL;
}

static void
createIssueAppend(const int nbTpl, const int nbAtr, const int nbQry)
{
  ARG *argP;
  pthread_t thread;

  argP = calloc(1, sizeof(ARG));
  argP->nbQry = nbQry;
  argP->nbTpl = nbTpl;
  argP->nbAtr = nbAtr;

  pthread_create(&thread, NULL, issueAppend, (void *)argP);
  pthread_detach(thread);
}

static void
printTime(struct timeval end, struct timeval begin)
{
  unsigned long diff;
  
  diff = (end.tv_sec - begin.tv_sec) * 1000 * 1000 + (end.tv_usec - begin.tv_usec);
  printf("%ld.%ld sec\n", diff / (1000 * 1000), diff % (1000 * 1000));
}

static void
exeAppend(const int nbQuery, const int nbTpl, const int nbAtr)
{
  int i, j;
  unsigned int max;
  struct timeval begin, end;

  max = (unsigned int)(nbTpl * nbAtr);

  gettimeofday(&begin, NULL);
  for (i = 0; i < nbTpl; i ++) {
    for (j = 0; j < nbAtr; j ++) {
      createIssueAppend(i, j, nbQuery);
    }
  }
  
  while (1) {
    usleep(1000);
    pthread_mutex_lock(&Mutex);
    if (Finished == max) {
      pthread_mutex_unlock(&Mutex);
      break;
    }
    pthread_mutex_unlock(&Mutex);
  }
  gettimeofday(&end, NULL);
  printTime(end, begin);
}

static void
printUsage(void)
{
  printf("Usage:\n");
  printf("\t program nbQuery nbTpl nbAtr\n");
  exit(1);
}

static void
chkInput(const int argc)
{
  if (argc != 4)
    printUsage();
}

static void
init(void)
{
  if (pthread_mutex_init(&Mutex, NULL)) ERR;
  Finished = 0;
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int 
main(const int argc, char *argv[])
{
  int nbTpl, nbAtr, nbQry;
  
  chkInput(argc);
  init();
  nbQry = atoi(argv[1]);
  nbTpl = atoi(argv[2]);
  nbAtr = atoi(argv[3]);
  exeAppend(nbQry, nbTpl, nbAtr);
    
  return 0;
}
