#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#define LISTENSIZE 128

/***************************************************************
 *
 * Function
 *
 ***************************************************************/
extern int 
createConnection(const int port)
{ 
  int sockfd;
  int optval = 1;
  struct sockaddr_in addr;
  char hostname[BUFFSIZE];

  /*
   * Set parameters
   */
  if (gethostname(hostname, BUFFSIZE) == -1) ERR;
  bzero((char *)&addr, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = htonl(INADDR_ANY);
  addr.sin_port = htons(port);

  /*
   * Socket, bind & listen
   */
  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) ERR;
  if (setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof(optval)) == -1) ERR;
  if (setsockopt(sockfd, IPPROTO_TCP, TCP_NODELAY, &optval, sizeof(optval)) == -1) ERR;
  if (bind(sockfd, (struct sockaddr *)&addr, sizeof(struct sockaddr_in)) == -1) ERR;
  if (listen(sockfd, LISTENSIZE) == -1) ERR;

  return sockfd;
}
