/*******************************************************
 *
 *                    Header files
 *
 *******************************************************/
#include <arpa/inet.h>
#include <fcntl.h>
#include <math.h>
#include <netdb.h>
#include <netinet/in.h>
#include <pthread.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <unistd.h>
#include <errno.h>
#include <assert.h>
#include <netinet/tcp.h>


/*******************************************************
 *
 * Definition
 *
 *******************************************************/
#ifdef DEBUG
#define C(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%c)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define D(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%d)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define P(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%p)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define L(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%ld)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define LL(val) do {fprintf(stderr, "%d %16s %4d %24s %32s: (%lld)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define S(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%s)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define F(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%f)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define N       do {fprintf(stderr, "%d %16s %4d %24s\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__); fflush(stderr);} while (0)
#define ERR     do {perror("ERROR"); N; exit(1);} while (0)
#define ERR2    do {perror("ERROR"); N; pthread_exit(NULL);} while (0)
#else
#define C(val)   do {} while (0)
#define D(val)   do {} while (0)
#define P(val)   do {} while (0)
#define L(val)   do {} while (0)
#define LL(val)  do {} while (0)
#define S(val)   do {} while (0)
#define F(val)   do {} while (0)
#define N        do {} while (0)
#define ERR      do {} while (0)
#endif

/*******************************************************
 *
 * Typedef
 *
 *******************************************************/
typedef enum {
  FALSE,
  TRUE
} BOOLEAN;
typedef enum {
  ANSWER_APPEND, 
  ANSWER_BEGIN, 
  ANSWER_COMMIT, 
  ANSWER_CREATE_INDEX, 
  ANSWER_CREATE_MONITOR, 
  ANSWER_CREATE_TABLE, 
  ANSWER_DROP_TABLE, 
  ANSWER_DROP_INDEX, 
  ANSWER_DELETE, 
  ANSWER_FINISH_MONITOR_RUN, 
  ANSWER_INSERT, 
  ANSWER_NOT_BEGIN, 
  ANSWER_PARSE_ERROR, 
  ANSWER_RELATION, 
  ANSWER_ROLLBACK_NO_BUFFERPOOL, 
  ANSWER_ROLLBACK_USER_REQUEST, 
  ANSWER_SHOW_MONITOR,
  ANSWER_SHOW_SCHEMA,
  ANSWER_UNACCEPTABLE
} TYPE_OF_ANSWER;
typedef enum {
  OPERATE_APPEND, 
  OPERATE_COMMIT, 
  OPERATE_CREATE_INDEX, 
  OPERATE_CREATE_MONITOR, 
  OPERATE_CREATE_TABLE, 
  OPERATE_DELETE, 
  OPERATE_DROP_TABLE, 
  OPERATE_DROP_INDEX, 
  OPERATE_INSERT, 
  OPERATE_SELECT, 
  OPERATE_SHOW_MONITOR,
  OPERATE_SHOW_SCHEMA,
  OPERATE_RUN_MONITOR, 
  OPERATE_UNACCEPTABLE
} TYPE_OF_OPERATION;

#ifdef USE_ERTF
#include </usr/src/lib/libpthread/thread/kraft_ertf.h>
#ifndef _BUFFSIZE_H
#include "buffsize.h"
#define _BUFFSIZE_H
#endif
typedef struct _QUEUE_LIST {
  long long ary[QUEUE_LIST_SIZE];
  long long flag[QUEUE_LIST_SIZE];
  char cs[QUEUE_LIST_SIZE];
  int policy[QUEUE_LIST_SIZE];
  struct _QUEUE_LIST *next;
  int line;
  char func[BUFFSIZE];
} QUEUE_LIST;
QUEUE_LIST HeadQueueList;
QUEUE_LIST *TailQueueListP;
pthread_mutex_t MutexForQueueList;
#endif
