#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _BUFFSIZE_H
#define _BUFFSIZE_H
#include "buffsize.h"
#endif

#ifndef _LOCK_MODE_H
#define _LOCK_MODE_H
#include "lockMode.h"
#endif


/****************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static int
getNumOfTuple(const TUPLE headTuple)
{
  int numOfTuple;
  TUPLE *pTuple;

  for (numOfTuple = 0, pTuple = headTuple.next;
       pTuple != NULL;
       pTuple = pTuple->next) {
    numOfTuple++;
  }

  return numOfTuple;
}

static int
getIdOfOrderAttr(const ATTR attr[], const char schemaName[], const char attrName[], const int numOfAttr)
{
  int attrid;
  int idOfOrderAttr = -1;

  for (attrid = 0;
       attrid < numOfAttr;
       attrid++) {
    if ((strncmp(attr[attrid].attrName, attrName, strlen(attrName)) == 0) &&
        (strncmp(attr[attrid].schemaName, schemaName, strlen(schemaName)) == 0)) {
      idOfOrderAttr = attrid;
      break;
    }
  }
  if (idOfOrderAttr == -1) {
    printf("idOfOrderAttr == -1 in getIdOfOrderAttr\n");
    exit(1);
  }

  return idOfOrderAttr;
}

static int
getByteOffsetForSort(const ATTR attr[], const int idOfOrderAttr)
{
  int attrid;
  int byteOffset;

  for (byteOffset = 0, attrid = 0;
       attrid < idOfOrderAttr;
       attrid++) {
    byteOffset += attr[attrid].sizOfAttr;
  }

  return byteOffset;
}

static void
quickSortInAscForInt(int a[], 
                     const int n, 
                     const int k, 
                     TUPLE *arrayTuplePointer[])
{
  TUPLE *vTuple;
  TUPLE *tTuple;
  int v, t, i, j, l, r;

  l = 0;
  r = n;
  while (r > l) {
    vTuple = arrayTuplePointer[r];
    v = a[r];
    i = l - 1;
    j = r;
    for (;;) {
      do {i++;} while (a[i] < v);
      do {j --;} while (a[j] > v);
      if (i >= j) {
        break;
      }
      t = a[i];
      tTuple = arrayTuplePointer[i];
      a[i] = a[j];
      arrayTuplePointer[i] = arrayTuplePointer[j];      
      a[j] = t;
      arrayTuplePointer[j] = tTuple;
    }
    t = a[i];
    tTuple = arrayTuplePointer[i];
    a[i] = a[r];
    arrayTuplePointer[i] = arrayTuplePointer[r];      
    a[r] = t;
    arrayTuplePointer[r] = tTuple;
    if (i >= k) {
      r = i - 1;
    }
    if (i <= k) {
      l = i + 1;
    }
  }
}

static void
quickSortInDescForInt(int a[], const int n, const int k, TUPLE *arrayTuplePointer[])
{
  TUPLE *vTuple;
  TUPLE *tTuple;
  int v, t, i, j, l, r;

  l = 0;
  r = n;
  while (r > l) {
    vTuple = arrayTuplePointer[r];
    v = a[r];
    i = l - 1;
    j = r;
    for (;;) {
      do {i++;} while (a[i] > v);
      do {j --;} while (a[j] < v);
      if (i >= j) {
        break;
      }
      t = a[i];
      a[i] = a[j];
      a[j] = t;
      tTuple = arrayTuplePointer[i];
      arrayTuplePointer[i] = arrayTuplePointer[j];      
      arrayTuplePointer[j] = tTuple;
    }
    t = a[i];
    a[i] = a[r];
    a[r] = t;
    tTuple = arrayTuplePointer[i];
    arrayTuplePointer[i] = arrayTuplePointer[r];      
    arrayTuplePointer[r] = tTuple;
    if (i >= k) {
      r = i - 1;
    }
    if (i <= k) {
      l = i + 1;
    }
  }
}

static void
quickSortInAscForDouble(double a[], const int n, const int k, TUPLE *arrayTuplePointer[])
{
  TUPLE *vTuple;
  TUPLE *tTuple;
  double v, t;
  int i, j, l, r;

  l = 0;
  r = n;
  while (r > l) {
    vTuple = arrayTuplePointer[r];
    v = a[r];
    i = l - 1;
    j = r;
    for (;;) {
      do {i++;} while (a[i] < v);
      do {j --;} while (a[j] > v);
      if (i >= j) {
        break;
      }
      t = a[i];
      tTuple = arrayTuplePointer[i];
      a[i] = a[j];
      arrayTuplePointer[i] = arrayTuplePointer[j];      
      a[j] = t;
      arrayTuplePointer[j] = tTuple;
    }
    t = a[i];
    tTuple = arrayTuplePointer[i];
    a[i] = a[r];
    arrayTuplePointer[i] = arrayTuplePointer[r];      
    a[r] = t;
    arrayTuplePointer[r] = tTuple;
    if (i >= k) {
      r = i - 1;
    }
    if (i <= k) {
      l = i + 1;
    }
  }
}

static void
quickSortInDescForDouble(double a[], const int n, const int k, TUPLE *arrayTuplePointer[])
{
  TUPLE *vTuple;
  TUPLE *tTuple;
  double v, t;
  int i, j, l, r;
  
  for (l = 0, r = n; r <= l; ) {
    vTuple = arrayTuplePointer[r];
    v = a[r];
    i = l - 1;
    j = r;
    for (;;) {
      do {i++;} while (a[i] > v);
      do {j --;} while (a[j] < v);
      if (i >= j) {
        break;
      }
      t = a[i];
      tTuple = arrayTuplePointer[i];
      a[i] = a[j];
      arrayTuplePointer[i] = arrayTuplePointer[j];      
      a[j] = t;
      arrayTuplePointer[j] = tTuple;
    }
    t = a[i];
    tTuple = arrayTuplePointer[i];
    a[i] = a[r];
    arrayTuplePointer[i] = arrayTuplePointer[r];      
    a[r] = t;
    arrayTuplePointer[r] = tTuple;
    if (i >= k) {
      r = i - 1;
    }
    if (i <= k) {
      l = i + 1;
    }
  }
}

/****************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern TUPLE
sortAnswerTupleByOrder(ANSWER answer, const ORDER_INFO orderInfo)
{
  int byteOffset;
  int numOfTuple;
  int tupleid;
  int idOfOrderAttr;
  int *intArray;
  double *doubleArray;
  TUPLE **arrayTuplePointer;
  TUPLE *pTuple;

  if (orderInfo.orderType == NO_ORDER_TYPE) {
    return answer.headTuple;
  }

  numOfTuple = getNumOfTuple(answer.headTuple);
  idOfOrderAttr = getIdOfOrderAttr(answer.attr, orderInfo.schemaName, orderInfo.attrName, answer.numOfAttr);
  byteOffset = getByteOffsetForSort(answer.attr, idOfOrderAttr);

  if ((arrayTuplePointer = calloc(numOfTuple, sizeof(TUPLE *))) == NULL) ERR;
  switch (answer.attr[idOfOrderAttr].attrType) {
  case INT:    
    if ((intArray = (int *)calloc(numOfTuple, sizeof(int))) == NULL) ERR;
    break;
  case DOUBLE: 
    if ((doubleArray = (double *)calloc(numOfTuple, sizeof(double))) == NULL) ERR;
    break;
  default: 
    printf("Not suppoted yet\n");
    exit(1);
    break;
  }
  
  for (pTuple = answer.headTuple.next, tupleid = 0; 
       tupleid < numOfTuple; 
       pTuple = pTuple->next, tupleid++) {
    arrayTuplePointer[tupleid] = pTuple;
    switch (answer.attr[idOfOrderAttr].attrType) {    
    case INT:  
      memcpy(&intArray[tupleid], (int *)(pTuple->obj + byteOffset), sizeof(int));    
      break;
    case DOUBLE: 
      memcpy(&doubleArray[tupleid], (double *)(pTuple->obj + byteOffset), sizeof(double)); 
      break;
    default: 
      exit(1); 
      break;
    }
  }

  switch (orderInfo.orderType) {
  case ASC_ORDER_TYPE:
    switch (answer.attr[idOfOrderAttr].attrType) {    
    case INT:    
      quickSortInAscForInt(intArray, (numOfTuple-1), (numOfTuple/2), arrayTuplePointer);       
      break;
    case DOUBLE: 
      quickSortInAscForDouble(doubleArray, (numOfTuple-1), (numOfTuple/2), arrayTuplePointer); 
      break;
    default: 
      exit(1); 
      break;
    }
    break;
  case DESC_ORDER_TYPE:
    switch (answer.attr[idOfOrderAttr].attrType) {    
    case INT:    
      quickSortInDescForInt(intArray, (numOfTuple-1), (numOfTuple/2), arrayTuplePointer);       
      break;
    case DOUBLE: 
      quickSortInDescForDouble(doubleArray, (numOfTuple-1), (numOfTuple/2), arrayTuplePointer); 
      break;
    default: 
      exit(1); 
      break;
    }
    break;
  case NO_ORDER_TYPE:
    printf("NO_ORDER_TYPE in sortAnswerTupleByOrder\n");
    exit(1);
    break;
  }

  for (pTuple = &(answer.headTuple), tupleid = 0; 
       tupleid < numOfTuple;
       pTuple = pTuple->next, tupleid++) {
    pTuple->next = arrayTuplePointer[tupleid];
    pTuple->next->prev = pTuple;
  }
  pTuple->next = NULL; /* Terminate */

  switch (answer.attr[idOfOrderAttr].attrType) {    
  case INT:    
    free(intArray);    
    break;
  case DOUBLE: 
    free(doubleArray); 
    break;
  default: 
    exit(1); 
    break;
  }
  free(arrayTuplePointer);

  return answer.headTuple;
}
