#include "common.h"
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include <dirent.h>
#include <sys/errno.h>
#include "buffsize.h"
#include "schemaDir.h"
#include "dataDir.h"

extern void sendback(const int sockfd, const void *ptr, const int size, const int flag);

/****************************************************************
 *
 * Function
 *
 ***************************************************************/
static void
sendAllOfSchema(const int acptfd)
{
  char schemaDirName[BUFFSIZE];
  BOOLEAN finish = FALSE;
  DIR *pDir;
  struct dirent *pDirent;

  bzero(schemaDirName, BUFFSIZE);
  sprintf(schemaDirName, "%s/%s", getenv("HOME"), SCHEMA_DIR);
  if ((pDir = opendir(schemaDirName)) == NULL) ERR;
  while (1) {
    pDirent = readdir(pDir);
    if (pDirent == NULL) {
      finish = TRUE;
      sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
      break;
    }
    else if ((strncmp(pDirent->d_name, ".", strlen(".")) != 0) && (strncmp(pDirent->d_name, "..", strlen("..")) != 0)) {
      finish = FALSE;
      sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
      sendback(acptfd, pDirent->d_name, BUFFSIZE, 0);
    }
  } 
  closedir(pDir);
}

static void
sendSingleSchema(const int acptfd, const char schemaName[])
{
  int fd;
  extern int errno;
  char schemaInfo[BUFFSIZE];
  char schemaFileName[BUFFSIZE];
  FILE *fpin;
  BOOLEAN finish;
  
  bzero(schemaFileName, BUFFSIZE);
  sprintf(schemaFileName, "%s/%s/%s", getenv("HOME"), SCHEMA_DIR, schemaName);
  
  fd = open(schemaFileName, O_RDONLY);
  if ((fd == -1) && (errno == ENOENT)) {
    finish = FALSE;
    sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
    bzero(schemaInfo, BUFFSIZE);
    strncpy(schemaInfo, "No such table", strlen("No such table"));
    sendback(acptfd, schemaInfo, BUFFSIZE, 0);
  }
  else {
    if (close(fd) == -1) ERR;
    if ((fpin = fopen(schemaFileName, "r")) == NULL) ERR;
    while (fgets(schemaInfo, sizeof(schemaInfo), fpin)) {
      finish = FALSE;
      sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
      schemaInfo[strlen(schemaInfo)-1] = '\0';
      sendback(acptfd, schemaInfo, BUFFSIZE, 0);
    }
    fclose(fpin);
  }    
  finish = TRUE;
  sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
}

extern void
sendSchema(const int acptfd, const char query[])
{
  int left;
  int right;
  int qid;
  char schemaName[BUFFSIZE];

  qid = 0;
  while (qid < BUFFSIZE) {
    if ((query[qid] == '\\') && strncmp(&query[qid], "\\d", strlen("\\d")) == 0) {
      qid += strlen("\\d");
      break;
    }
    qid ++;
  }
  while (qid < BUFFSIZE) {
    if ((query[qid] != '\0') && (query[qid] != '\n')) {
      break;
    }
    qid ++;
  }
  if (qid == BUFFSIZE) {
    sendAllOfSchema(acptfd);
  }
  else {
    while (query[qid] == ' ') {
      qid ++;
    }
    left = qid;
    while ((query[qid] != '\n') && (query[qid] != '\0')) {
      qid ++;
    }
    right = qid;
    bzero(schemaName, BUFFSIZE);
    strncpy(schemaName, &query[left], right-left);
    sendSingleSchema(acptfd, schemaName);
  }
}
