#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#include "ipc.h"

/****************************************************************
 *
 * Declarations
 *
 ***************************************************************/
extern void releaseSensorSegmentAttrList(SENSOR_SEGMENT_ATTR_LIST *pHeadSSAL);

/****************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static SENSOR_SEGMENT_ATTR_LIST 
getHeadSsalForAnswer(const ANSWER answer)
{
  int i;
  SENSOR_SEGMENT_ATTR_LIST head, *p;

  bzero(&head, sizeof(SENSOR_SEGMENT_ATTR_LIST));
  p = &head;
  for (i = 0; i < answer.numOfAttr; i++) {
    switch (answer.attr[i].attrType) {
    case SENSOR_SEGMENT_DOUBLE:
      if ((p->next = calloc(1, sizeof(SENSOR_SEGMENT_ATTR_LIST))) == NULL) ERR;
      p = p->next;
      strncpy(p->attrName, answer.attr[i].attrName, strlen(answer.attr[i].attrName));
      p->attrid = i;
      break;
    default:
      break;
    }
  }

  return head;
}

extern SENSOR_SEGMENT 
getHeadSensorSegment(const int segmentAttrid, const ATTR answerAttr[], TUPLE *pTuple)
{
  int attrid;
  int offset;
  SENSOR_SEGMENT headSensorSegment;

  for (offset = 0, attrid = 0; attrid < segmentAttrid; attrid++) {
    offset += answerAttr[attrid].sizOfAttr;
  }
  memcpy(&headSensorSegment, (SENSOR_SEGMENT *)(pTuple->obj + offset), sizeof(SENSOR_SEGMENT));
  headSensorSegment.offset = offset;

  return headSensorSegment;
}

extern void
sendAnswerListToClient(int acptfd, ANSWER answer)
{
  int i;
  int szsa;  /* SiZe of Sensor Array */
  int szpkt; /* Size of Packet */
  char *pktp;
  TUPLE *atp;
  SENSOR *sp;  
  SENSOR_SEGMENT headSS, *ssp;
  SENSOR_SEGMENT_ATTR_LIST headSsal, *ssalp;
  METACOMM mc;

  for (answer.byteOfTuple = 0, i = 0; i < answer.numOfAttr; i++) 
    answer.byteOfTuple += answer.attr[i].sizOfAttr;

  szpkt = 0;
  szpkt += sizeof(ANSWER);
  szpkt += sizeof(METACOMM);
  if ((pktp = calloc(1, szpkt)) == NULL) ERR;
  mc.commType = TYPE_ANSWER;
  mc.numOfObj = 1;
  memcpy((METACOMM *)&pktp[szpkt - (sizeof(ANSWER) + sizeof(METACOMM))], &mc, sizeof(METACOMM));
  memcpy((ANSWER *)&pktp[szpkt - (sizeof(ANSWER))], &answer, sizeof(ANSWER));
  szpkt += sizeof(METACOMM);
  szpkt += (sizeof(ATTR) * answer.numOfAttr);
  if ((pktp = realloc(pktp, szpkt)) == NULL) ERR;
  mc.commType = TYPE_ATTR;
  mc.numOfObj = answer.numOfAttr;
  memcpy((METACOMM*)&pktp[szpkt - (sizeof(ATTR)*answer.numOfAttr+sizeof(METACOMM))], &mc, sizeof(METACOMM));
  memcpy((ATTR*)&pktp[szpkt - (sizeof(ATTR)*answer.numOfAttr)], answer.attr, (sizeof(ATTR)*answer.numOfAttr));

  headSsal = getHeadSsalForAnswer(answer);
  for (atp = answer.headTuple.next; atp != NULL; atp = atp->next) {
    szpkt += sizeof(METACOMM);
    szpkt += answer.byteOfTuple;    
    if ((pktp = realloc(pktp, szpkt)) == NULL) ERR;
    mc.commType = TYPE_RELATION;
    mc.numOfObj = 1;
    memcpy((METACOMM *)&pktp[szpkt - (answer.byteOfTuple + sizeof(METACOMM))], &mc, sizeof(METACOMM));
    memcpy((void *)&pktp[szpkt - answer.byteOfTuple], atp->obj, answer.byteOfTuple);

    for (ssalp = headSsal.next; ssalp != NULL; ssalp = ssalp->next) {

      headSS = getHeadSensorSegment(ssalp->attrid, answer.attr, atp);
      for (ssp = headSS.next; ssp != NULL; ssp = ssp->next) {

        ssp->offset = headSS.offset;
        szpkt += sizeof(METACOMM); 
        szpkt += sizeof(SENSOR_SEGMENT);
        if ((pktp = realloc(pktp, szpkt)) == NULL) ERR;
        mc.commType = TYPE_SENSOR_SEGMENT;
        mc.numOfObj = 1;
        memcpy((METACOMM *)&pktp[szpkt-(sizeof(SENSOR_SEGMENT)+sizeof(METACOMM))], &mc, sizeof(METACOMM));
        memcpy((SENSOR_SEGMENT *)&pktp[szpkt-(sizeof(SENSOR_SEGMENT))], ssp, sizeof(SENSOR_SEGMENT));

        for (sp = ssp->headSensor.next; sp != NULL; sp = sp->next) {
          szsa = sp->sdobj.szsa * sizeof(double);

          szpkt += sizeof(METACOMM);
          szpkt += (sizeof(SDOBJ) + szsa);

          if ((pktp = realloc(pktp, szpkt)) == NULL) ERR;
          mc.commType = TYPE_SENSOR;
          mc.numOfObj = 1;
          
          memcpy((METACOMM *)&pktp[szpkt - (sizeof(METACOMM) + sizeof(SDOBJ) + szsa)], &mc, sizeof(METACOMM));
          memcpy((SDOBJ *)&pktp[szpkt - (sizeof(SDOBJ) + szsa)], &sp->sdobj, sizeof(SDOBJ));
          memcpy((double *)&pktp[szpkt - szsa], sp->sdobj.v, szsa);
        }
      }
    }
  }

  /*
   * OK, sending one marshalized packet 
   */
  if (send(acptfd, &szpkt, sizeof(int), 0) == -1) ERR;
  if (send(acptfd, pktp, szpkt, 0) == -1) ERR;

  /*
   * Releasing the area
   */
  releaseSensorSegmentAttrList(&headSsal);
  free(pktp);
}
