#include "common.h"
#include "buffsize.h"
#include "libWrapper.h"
#include <sys/wait.h>
#include "schema.h"
#include "selectFrom.h"
#define COMM_BUFFSIZE 128
#define MEGA (1000 * 1000)
/***************************************************************
 *
 * Prototype
 *
 ***************************************************************/
extern void sendQuery(const char query[], const int sockfd);
extern void sendExitAndCloseSockfd(const int sockfd);
extern TYPE_OF_ANSWER recvTypeOfAnswer(const int sockfd);
extern BOOLEAN isThisAppend(const char query[]);
extern int connectKraftByClient(void);

typedef struct _EXEC_TIME {
  long long llExecTime;  
  struct _EXEC_TIME *next;
} EXEC_TIME;

static pthread_mutex_t MutexForCounter;
static char *Period;
static char *Duration;
static int MaxNumOfThread;
static int NumberOfFinishedMonitors;


/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static void
recordExecTime(const int myThreadid, EXEC_TIME headExecTime)
{
  FILE *fp;
  EXEC_TIME *execTimeP;
  char myExecTimeLogFile[BUFFSIZE];

  bzero(myExecTimeLogFile, BUFFSIZE);
  sprintf(myExecTimeLogFile, "/tmp/MONITOR_EXEC_TIME_LOG/%d", myThreadid);
  if ((fp = fopen(myExecTimeLogFile, "a")) == NULL) ERR;
  while (headExecTime.next != NULL) {
    execTimeP = headExecTime.next;
    headExecTime.next = headExecTime.next->next;
    fprintf(fp, "%lld\n", execTimeP->llExecTime);
    free(execTimeP);
  }
  fclose(fp);
}

static void
updateThreadCounter(void)
{
  if (pthread_mutex_lock(&MutexForCounter) != 0) ERR;
  NumberOfFinishedMonitors ++;
  if (pthread_mutex_unlock(&MutexForCounter) != 0) ERR;
}

static void *
monitor(void *arg)
{
  int ack;
  int kraftfd;
  int myThreadid = (int)arg;
  char query[QUERY_BUFFSIZE];
  struct timeval beforeSendQuery;
  struct timeval afterSendQuery;
  TYPE_OF_ANSWER typeOfAnswer;
  EXEC_TIME *execTimeP;
  EXEC_TIME headExecTime;

  bzero(&headExecTime, sizeof(EXEC_TIME));
  kraftfd = connectKraftByClient();

  execTimeP = &headExecTime;
  bzero(query, BUFFSIZE);
  sprintf(query, "run %s during %s", Period, Duration);
  sendQuery(query, kraftfd);    
  while (1) {
    if (gettimeofday(&beforeSendQuery, NULL) == -1) ERR;
    if ((typeOfAnswer = recvTypeOfAnswer(kraftfd)) == ANSWER_FINISH_MONITOR_RUN) {
      sendExitAndCloseSockfd(kraftfd);
      break;
    }
    //printResultForRelation(kraftfd);
    if (send(kraftfd, &ack, sizeof(int), 0) == -1) ERR;
    if (gettimeofday(&afterSendQuery, NULL) == -1) ERR;
    if ((execTimeP->next = calloc(1, sizeof(EXEC_TIME))) == NULL) ERR;
    execTimeP = execTimeP->next;
    execTimeP->llExecTime = (long long)(afterSendQuery.tv_sec - beforeSendQuery.tv_sec) * (long long)MEGA + (long long)(afterSendQuery.tv_usec - beforeSendQuery.tv_usec);
  } 
  recordExecTime(myThreadid, headExecTime);
  updateThreadCounter();

  pthread_exit(NULL);
  return NULL;
}

static void
waitall(void)
{
  while (1) {
    if (pthread_mutex_lock(&MutexForCounter) != 0) ERR;
    if (NumberOfFinishedMonitors == MaxNumOfThread) {
      if (pthread_mutex_unlock(&MutexForCounter) != 0) ERR;
      break;
    }
    else {
      if (pthread_mutex_unlock(&MutexForCounter) != 0) ERR;
      sleep(1);
    }
  }

  printf("-----------------------------------------------------\n");
  printf("\n");
  printf("                    FINISH ALL                       \n");
  printf("\n");
  printf("-----------------------------------------------------\n");
}

static void
initRXMonitor(const int argc, char *argv[])
{
  char comm[COMM_BUFFSIZE];

  if (argc != 4) {
    printf("Usage: program Period Duration MaxNumOfThread\n");
    exit(1);
  }
  Period = argv[1];
  Duration = argv[2];
  MaxNumOfThread = atoi(argv[3]);

  NumberOfFinishedMonitors = 0;
  if (pthread_mutex_init(&MutexForCounter, NULL) != 0) ERR;

  bzero(comm, COMM_BUFFSIZE);
  sprintf(comm, "rm -fr  /tmp/MONITOR_EXEC_TIME_LOG");
  system(comm);

  bzero(comm, COMM_BUFFSIZE);
  sprintf(comm, "mkdir -p /tmp/MONITOR_EXEC_TIME_LOG");
  system(comm);
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int 
main(const int argc, char *argv[])
{
  int i;
  pthread_t thread;

  initRXMonitor(argc, argv);
  for (i = 1; i <= MaxNumOfThread; i ++) {
    if (pthread_create(&thread, NULL, monitor, (void *)i) != 0) ERR;
    if (pthread_detach(thread) != 0) ERR;
    usleep(1000 * 1);
  }
  waitall();

  return 0;
}
