#include "common.h"
#include "libWrapper.h"

typedef struct _ID_LIST
{
  pthread_t id;
  struct _ID_LIST *next;
} ID_LIST;

typedef struct _PRIORITY_LIST
{
  ID_LIST headIdList;
  struct timeval deadline;
  struct _PRIORITY_LIST *next;
} PRIORITY_LIST;


/****************************************************************
 *
 * Gloval variable
 *
 ***************************************************************/
static PRIORITY_LIST HeadPriorityList;


/****************************************************************
 *
 * Function
 *
 ***************************************************************/
static long
getDiffTime(struct timeval newTrans, struct timeval inList)
{
  return (((newTrans.tv_sec - inList.tv_sec) * 1000 * 1000) + (newTrans.tv_usec - inList.tv_usec));
}

extern void
appendIdToPriorityList(const pthread_t id, const struct timeval deadline)
{
  PRIORITY_LIST *pPriorityList;
  PRIORITY_LIST *pNewPriorityList;
  ID_LIST *idList;
  long diffTime;

  for (pPriorityList = &HeadPriorityList;
       pPriorityList->next != NULL;
       pPriorityList = pPriorityList->next) {
    diffTime = getDiffTime(deadline, pPriorityList->deadline);

    if (diffTime < 0) {
      if ((pNewPriorityList = calloc(1, sizeof(PRIORITY_LIST))) == NULL) ERR;
      pNewPriorityList->deadline = deadline;
      if ((pNewPriorityList->headIdList.next = calloc(1, sizeof(ID_LIST))) == NULL) ERR;
      pNewPriorityList->headIdList.next->id = id;
      
      pNewPriorityList->next = pPriorityList->next;
      pPriorityList->next = pNewPriorityList;
    }
    else if (diffTime == 0) {
      for (idList = &pPriorityList->headIdList;
           idList->next != NULL;
           idList = idList->next) {;;;;;}
      if ((idList->next = calloc(1, sizeof(ID_LIST))) == NULL) ERR;
      idList->next->id = id;
    }
  }
  if (pPriorityList->next == NULL) {
    if ((pPriorityList->next = calloc(1, sizeof(PRIORITY_LIST))) == NULL) ERR;
    pPriorityList = pPriorityList->next;
    pPriorityList->deadline = deadline;
    if ((pPriorityList->headIdList.next = calloc(1, sizeof(ID_LIST))) == NULL) ERR;
    pPriorityList->headIdList.next->id = id;
  }
}

extern void
releaseIdFromPriorityList(const pthread_t id)
{
  PRIORITY_LIST *pPriorityList;
  ID_LIST *idList;
  ID_LIST *trashIdList;

  for (pPriorityList = HeadPriorityList.next;
       pPriorityList != NULL;
       pPriorityList = pPriorityList->next) {
    for (idList = &(pPriorityList->headIdList);
         idList->next != NULL;
         idList = idList->next) {
      if (pthread_equal(idList->next->id, id) != 0) {
#ifdef DEBUG
        printf("id: %d\n", (int)id);
#endif
        trashIdList = idList->next;
        idList->next = idList->next->next;
        free(trashIdList);
        return;
      }
    }
  }
}
