#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include "port.h"
#include "host.h"
//#include "extern.h"
#include "memsize.h"
#include "mmgr.h"
#include "cmp.h"
#include <zlib.h>
#ifndef _LOG_INFO_H
#define _LOG_INFO_H
#include "logInfo.h"
#endif

#include "threadInfo.h"

/****************************************************************
 *
 * Declaration
 *
 ***************************************************************/
extern void exeGrpCmt(void);
extern void sendback(const int sockfd, const void *ptr, const int size, const int flag);
extern void recvback(const int sockfd, void *ptr, const int size, const int flag);
extern void atomicExecuteParser(char query[], const int clifd);
extern void parser(char query[], const int clientfd);
extern void memRead(void);
extern void copyBuffPool(char *buffPool, int siz);
extern void chkpnt(char *memP);
extern void releaseMyTransaction(void);
extern void createTransInfo(const int dbClientFd, const int logfd);
extern int connectCli(const int port, const char hostname[]);
extern void sendMessage(const int acptfd, TYPE_OF_ANSWER typeOfAnswer);
extern void startInteractiveTransaction(const int clifd);
extern void sweeperGC(void);
extern void outputLoggingTime(void);

/****************************************************************
 *
 * Global Variale
 *
 ***************************************************************/
extern TID HeadTid, *TailTidP; /* Head & Tail Thread Id Information */
extern int NbSC;
extern pthread_mutex_t LkGrpLgLst;

/****************************************************************
 *
 * Private function
 *
 ***************************************************************/
static void
finThread(const int clifd)
{
  int fin;
  LOG_RECORD logRec;

  /* Close Connection to Log Server */
  logRec.type = PERSISTENT_EXIT;

  /* Close Connection to Client */
  if (send(clifd, &fin, sizeof(fin), 0) == -1) ERR;
  if (close(clifd) == -1) ERR;

  /* Byebye */
  pthread_exit(NULL);
}

static BOOLEAN
isExit(const char query[])
{
  return (strcmp(query, "exit") == 0) ? TRUE : FALSE;
}

static void
execUserCommand(const int clifd)
{
  char query[QUERY_BUFFSIZE];

  if (recv(clifd, query, QUERY_BUFFSIZE, MSG_WAITALL) == -1) ERR;
  if (isExit(query) == TRUE) {
    finThread(clifd);
  }
  else {
    atomicExecuteParser(query, clifd);
  }
}

/****************************************************************
 *
 * Public function
 *
 ***************************************************************/
extern void *
newThreadSensor(void *arg)
{
  int clifd = (int)arg;

  while (1) {
    //execCopyRelease(__LINE__, __func__);
    execUserCommand(clifd);
  }

  return NULL;
}

extern void *
newThreadClient(void *arg)
{
  int clifd = (int)arg;

  while (1) {
    //execCopyRelease(__LINE__, __func__);
    execUserCommand(clifd);
  }

  return NULL;
}
