#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _SIMSEQ_H
#define _SIMSEQ_H
#include "simseq.h"
#endif

#ifndef _WINDOW_H
#define _WINDOW_H
#include "window.h"
#endif

extern double 
compEuclid(SELECT_ATTR *sap, SENSOR *sp, const int nt)
{
	int i;
	double v = 0; /* Distance */

	for (i = 0; sp && ((nt && i < nt) || !nt); sp = sp->next, i++) 
		v += sp->sdobj.v[sap->said] * sp->sdobj.v[sap->s_said];
	
	return sqrt(v);
}
