#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _SIMSEQ_H
#define _SIMSEQ_H
#include "simseq.h"
#endif

#ifndef _WINDOW_H
#define _WINDOW_H
#include "window.h"
#endif

extern double 
compCorrel(SELECT_ATTR *sap, SENSOR *sp, const int nt)
{
	int i;
	double u = 0; /* Upper */
	double lx, ly; /* Lower */
	double _x = 0, _y = 0;

	for (i = 0; sp && ((nt && i < nt) || !nt); sp = sp->next, i++) {
		_x += sp->sdobj.v[sap->said];
		_y += sp->sdobj.v[sap->s_said];
	}
	_x /= i;
	_y /= i;

	for (u = 0, i = 0; sp && ((nt && i < nt) || !nt); sp = sp->next, i++) 
		u += (sp->sdobj.v[sap->said] - _x) * (sp->sdobj.v[sap->s_said] - _y);
	
	for (lx = 0, i = 0; sp && ((nt && i < nt) || !nt); sp = sp->next, i++) 
		lx += (sp->sdobj.v[sap->said] - _x) * (sp->sdobj.v[sap->said] - _x);
	lx /= i;

	for (ly = 0, i = 0; sp && ((nt && i < nt) || !nt); sp = sp->next, i++) 
		ly += (sp->sdobj.v[sap->s_said] - _y) * (sp->sdobj.v[sap->s_said] - _y);
	ly /= i;

	return u / (lx * ly);
}

/*
 * http://ja.wikipedia.org/wiki/%E7%9B%B8%E9%96%A2%E4%BF%82%E6%95%B0
 */
