#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include "dataDir.h"
#include "schemaDir.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

/****************************************************************
 *
 * Gloval variable
 *
 ***************************************************************/
extern SCHEMA HeadSchema;


/****************************************************************
 *
 * Functions
 *
 ***************************************************************/
extern BOOLEAN
dropTable(const char buff[])
{
  int buffid;
  int nameid;
  char schemaFileName[BUFFSIZE];
  char dataFileName[BUFFSIZE];
  char garbageFileName[BUFFSIZE];
  char tmpSchemaName[BUFFSIZE];
  char removeCommand[BUFFSIZE];
	char *hdp;
  SCHEMA *dropSchema;
  SCHEMA *pSchema;
  BOOLEAN err = FALSE;

  buffid = 0;
  while (1) {
    if ((buff[buffid] == 'd') && (strncmp(&buff[buffid], "drop table", strlen("drop table")) == 0)) {
      buffid += strlen("drop table");
      break;
    }
    else {
      buffid ++;
    }
  }
  
  while (buff[buffid] == ' ') {buffid ++;}

  bzero(tmpSchemaName, BUFFSIZE);
  nameid = 0;
  while (1) {
    if ((buff[buffid] == ' ') || (buff[buffid] == '\n') || (buff[buffid] == ';') || (buff[buffid] == '\0')) {
      break;
    }
    else {
      tmpSchemaName[nameid] = buff[buffid];
      nameid ++;
      buffid ++;
    }
  }

  for (dropSchema = NULL, pSchema = &HeadSchema; 
       pSchema != NULL; 
       pSchema = pSchema->next) {
    if (strncmp(pSchema->schemaName, tmpSchemaName, strlen(tmpSchemaName)) == 0) {
      dropSchema = pSchema;
      break;
    }
  }
  if (pSchema->next != NULL) {
    if (pthread_rwlock_wrlock(&(dropSchema->rwlock)) != 0) ERR;
    pSchema->next = pSchema->next->next;
    //wrlockAnswerTuple(dropSchema->headTuple);
    releaseBaseTupleForServer(dropSchema->headTuple, dropSchema->attr, dropSchema->numOfAttr);
    //unlockAnswerTuple(dropSchema->headTuple);
    free(dropSchema->attr);
    if (pthread_rwlock_unlock(&(dropSchema->rwlock)) != 0) ERR;
    free(dropSchema);
  }

	hdp = getenv("HOME");
  bzero(dataFileName, BUFFSIZE);
  sprintf(dataFileName, "%s/%s/%s", hdp, DATA_DIR, tmpSchemaName);
  bzero(removeCommand, BUFFSIZE);
  sprintf(removeCommand, "rm -fr %s", dataFileName); 
  system(removeCommand);

  bzero(garbageFileName, BUFFSIZE);
  sprintf(garbageFileName, "%s/%s/%s/garbage", hdp, DATA_DIR, tmpSchemaName);
  bzero(removeCommand, BUFFSIZE);
  sprintf(removeCommand, "rm -fr %s", garbageFileName); 
  system(removeCommand);

  bzero(schemaFileName, BUFFSIZE);
  sprintf(schemaFileName, "%s/%s/%s", hdp, SCHEMA_DIR, tmpSchemaName);
  bzero(removeCommand, BUFFSIZE);
  sprintf(removeCommand, "rm -fr %s", schemaFileName); 
  system(removeCommand);

  return err;
}
