#include "common.h"
#include "libWrapper.h"
#include "port.h"
#include "host.h"
#include "dataDir.h"
#include <sys/time.h>
#include <sys/resource.h>

#ifdef USE_ERTF
#include </usr/src/lib/libpthread/thread/kraft_sched.h>
#include </usr/src/lib/libpthread/thread/kraft_extern.h>
#include </usr/src/lib/libpthread/thread/kraft_ertf.h>
#endif

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _WINDOW_H
#define _WINDOW_H
#include "window.h"
#endif

#ifndef _SCHEMA_DIR_H
#define _SCHEMA_DIR_H
#include "schemaDir.h"
#endif

#ifndef _WINDOW_DIR_H
#define _WINDOW_DIR_H
#include "windowDir.h"
#endif

#ifndef _MEM_SIZE_H
#define _MEM_SIZE_H
#include "memsize.h"
#endif

#include "threadInfo.h"


/*******************************************************
 *
 * Declaration
 *
 *******************************************************/
extern void *newThreadGroupCommiter(void);
extern void initLockOfDBPage(void);
extern void initDBPages(void);
extern void *newThreadClient(void *arg);
extern void *newThreadSensor(void *arg);
extern void *newThreadChkptr(void *arg);
extern void initCpyMem(void);
extern void initGarbageOfSchema(SCHEMA *schemaP);
extern void initSerialGrpSnd(void); /* Can be seen by localLogClient.c */
extern void initDiskLogfd(void);
extern void initDiffLog(void);
extern void invokeRecovery(void);
extern void sendback(const int sockfd, const void *ptr, const int size, const int flag);
extern void createLogBufFileMaker(void);
extern void createLogBufFileReader(void);
extern void initMmgr(void);
extern void initSignal(void);
extern int  createConnection(const int port);
extern void setAttrInSchema(const char schemaName[], SCHEMA *schemaP);
extern void initLockOfThisSchema(SCHEMA *pSchema);
extern void initMonitorMgr(void);
extern void initSynchr(void);

/*******************************************************
 *
 * Global variables
 *
 *******************************************************/
extern SCHEMA HeadSchema;
extern METAW HeadMetaw;

/*******************************************************
 *
 * Private Function
 *
 *******************************************************/

static void
createThreadClient(const int acptfd)
{
	pthread_t thread;
  pthread_attr_t attr;

  if (pthread_attr_init(&attr) != 0) ERR;
  if (pthread_attr_setschedpolicy(&attr, SCHED_RR) != 0) ERR;
  if (pthread_create(&thread, &attr, (void *)newThreadClient, (void *)acptfd) != 0) ERR;
  //execCopyRelease(__LINE__, __func__);
  if (pthread_detach(thread) != 0) ERR;
}

static void
createThreadSensor(const int acptfd)
{
  pthread_t thread;
  pthread_attr_t attr;

  if (pthread_attr_init(&attr) != 0) ERR;
  if (pthread_attr_setschedpolicy(&attr, SCHED_RR) != 0) ERR;
  if (pthread_create(&thread, &attr, (void *)newThreadSensor, (void *)acptfd) != 0) ERR;
  //execCopyRelease(__LINE__, __func__);
  if (pthread_detach(thread) != 0) ERR;
}

static void
printNowReady(void)
{
  printf("###############################################################\n");
  printf("########[                                             ]########\n");
  printf("########[              DBMS is now READY              ]########\n");
  printf("########[                                             ]########\n");
  printf("###############################################################\n");
  fflush(stdout);
}

static void 
dbmain(void)
{
  int acptfd, width;
  int clifd; /* Client */
  int senfd; /* Sensor Channel */
  fd_set mask, readOk;
  struct timeval tv;

  /* Set Socket File Desctiptors */
  senfd = createConnection(DBMS_SENSOR_PORT);
  clifd = createConnection(DBMS_CLIENT_PORT);

  /* Prepare for select */
  FD_ZERO(&mask);
  FD_SET(senfd, &mask);
  FD_SET(clifd, &mask);
  width = clifd + 1;
  tv.tv_sec = 0;
  tv.tv_usec = 10;

  /* Now I am ready */
  printNowReady();

  /*
   * Main loop;
   */
  while (1) {
    readOk = mask;
    if (select(width, (fd_set *)&readOk, NULL, NULL, &tv) == -1) ERR;
    if (FD_ISSET(senfd, &readOk)) {
      if ((acptfd = accept(senfd, NULL, NULL)) == -1) ERR;
      createThreadSensor(acptfd);
    }
    if (FD_ISSET(clifd, &readOk)) {
      if ((acptfd = accept(clifd, NULL, NULL)) == -1) ERR;      
      createThreadClient(acptfd);
    }
  }
}

#ifdef USE_ERTF
static void
print_queue(void)
{
  int i;
  FILE *fp;
  QUEUE_LIST *queueListP;

  if ((fp = fopen("/tmp/result_print_queue", "w")) == NULL) ERR;
  for (queueListP = HeadQueueList.next;
       queueListP != NULL;
       queueListP = queueListP->next) {
    fprintf(fp, "------[%s:%d]------\n", queueListP->func, queueListP->line);
    for (i = 0; i < QUEUE_LIST_SIZE; i ++) {
      if (queueListP->flag[i] == 1) {
        if (queueListP->ary[i] < 0) {
          fprintf(fp, "%d:%c:%lld\n", queueListP->policy[i], queueListP->cs[i], queueListP->ary[i]);
        }
        else {
          fprintf(fp, "%d:%c: %lld\n", queueListP->policy[i], queueListP->cs[i], queueListP->ary[i]);
        }
      }
    }
    fprintf(fp, "\n");
  }
  fclose(fp);
}
#endif

static void
initPriority(void)
{
  if (setpriority(PRIO_PROCESS, 0, -20) == -1)
    perror("setpriority");
}

static void
initWindow(void)
{
  int fd;
  METAW *metawP;
  DIR *dirP;
  char file[BUFFSIZE];
	char *hdp;
  struct dirent *direntP;
	char path[BUFSIZ];

  bzero(&HeadMetaw, sizeof(METAW));
	bzero(path, BUFSIZ);
	sprintf(path, "%s/%s", getenv("HOME"), WINDOW_DIR);
  metawP = &HeadMetaw;
  if ((dirP = opendir(path)) == NULL) ERR;
  while (1) {
    direntP = readdir(dirP);
    if (direntP == NULL) {
      break;
    }
    else if ((strcmp(direntP->d_name, ".") != 0) && 
             (strcmp(direntP->d_name, "..") != 0)) {
      if ((metawP->next = calloc(1, sizeof(METAW))) == NULL) ERR;
      metawP = metawP->next;
      if ((metawP->w = calloc(1, sizeof(WINDOW))) == NULL) ERR;
      strcpy(metawP->w->name, direntP->d_name);
      bzero(file, BUFFSIZE);
			hdp = getenv("HOME");
      sprintf(file, "%s/%s/%s", hdp, WINDOW_DIR, direntP->d_name);
      S(file);
      if ((fd = open(file, O_RDONLY)) == -1) ERR;
      if (read(fd, &metawP->w->num, sizeof(int)) == -1) ERR;
      if ((metawP->w->p = calloc(metawP->w->num, sizeof(VT))) == NULL) ERR;
      if (read(fd, metawP->w->p, metawP->w->num * sizeof(VT)) == -1) ERR;
      if (close(fd) == -1) ERR;
    }
  }
  if (closedir(dirP) == -1) ERR;
}

static void 
initSchema(void)
{
  char schemaName[BUFFSIZE];
  char schemaDirName[BUFFSIZE];
  struct dirent *direntP;
  SCHEMA *schemaP;
	char path[BUFSIZ];
  DIR *dirP;

  bzero(&HeadSchema, sizeof(SCHEMA));
  bzero(schemaName, BUFFSIZE);
  bzero(schemaDirName, BUFFSIZE);
	bzero(path, BUFSIZ);
	sprintf(path, "%s/%s", getenv("HOME"), SCHEMA_DIR);

  schemaP = &HeadSchema;
  if ((dirP = opendir(path)) == NULL) ERR;
  while (1) {
    direntP = readdir(dirP);
    if (direntP == NULL) {
      break;
    }
    else if ((strcmp(direntP->d_name, ".") != 0) && (strcmp(direntP->d_name, "..") != 0)) {
      if ((schemaP->next = calloc(1, sizeof(SCHEMA))) == NULL) ERR;
      schemaP = schemaP->next;
      setAttrInSchema(direntP->d_name, schemaP);
      initLockOfThisSchema(schemaP);
      initGarbageOfSchema(schemaP);
    }
  }
  if (closedir(dirP) == -1) ERR;
}

static void  
initDBSThread(void)
{
#ifdef USE_ERTF
  bzero(&HeadQueueList, sizeof(QUEUE_LIST));
  TailQueueListP = &HeadQueueList;
  if (pthread_mutex_init(&MutexForQueueList, NULL)) ERR;
  if (pthread_setschedpolicy_kraft(pthread_self(), SCHED_ERTF) != 0) ERR;
  if (pthread_set_release_kraft(pthread_self(), -1) != 0) ERR;
#else
  //if (pthread_setschedpolicy_kraft(pthread_self(), SCHED_RR) != 0) ERR;
#endif
  pthread_yield();
}

/*
static void
initChkptr(void)
{
  createLogBufFileReader();
  createLogBufFileMaker();
}  
*/

static void
initdb(void)
{
  initDBPages();
  initSignal();
  initMonitorMgr();
  /* initPriority(); */
  initSchema();
  initWindow();
  initDBSThread();
  initSynchr();
  /*
   * initMmgr();
   * initChkptr();
   */
}

/*******************************************************
 *
 * Public Function
 *
 *******************************************************/
extern void
initLockOfThisSchema(SCHEMA *pSchema)
{
  if (pthread_rwlock_init(&(pSchema->rwlock), NULL) != 0) ERR;
  initLockOfDBPage();
} 

extern int 
main(void)
{
  initdb();
  //invokeRecovery();
  //execCopyRelease(__LINE__, __func__);
  dbmain();

  return 0;
}
