#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include <ctype.h>
#include "dataDir.h"
#include "schemaDir.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _TRANS_INFO_H
#define _TRANS_INFO_H
#include "transInfo.h"
#endif

#ifndef _LOG_INFO_H
#define _LOG_INFO_H
#include "logInfo.h"
#endif

/****************************************************************
 *
 * Declarations
 *
 ***************************************************************/
extern void initLockOfThisSchema(SCHEMA *pSchema);
extern void setAttrInSchema(const char schemaName[], SCHEMA *schemaP);

/****************************************************************
 *
 * Gloval variables
 *
 ***************************************************************/
extern SCHEMA HeadSchema;

/****************************************************************
 *
 * Definitions
 *
 ***************************************************************/
#ifndef _ATTR_LIST_H
#include "attrList.h"
#define _ATTR_LIST_H
#endif
typedef struct _NEW_SCHEMA_INFO {
  char schemaName[BUFFSIZE];
  int schemaSize;
  ATTR_LIST headAttrList;
} NEW_SCHEMA_INFO;

/************************************************************
 *
 * Private Functions
 *
 ************************************************************/
static PARSE_MSG
execCreateTableForDisk(NEW_SCHEMA_INFO newSchemaInfo)
{
  extern int errno;
  int fd;
  char dirFileName[BUFFSIZE];
  char schemaName[BUFFSIZE];
  char dataFileName[BUFFSIZE];
  char garbageFileName[BUFFSIZE];
  /* char indexFileName[BUFFSIZE]; */
  FILE *fp;
  ATTR_LIST *p;

  bzero(dirFileName, BUFFSIZE);
  sprintf(dirFileName, "%s/%s/%s", getenv("HOME"), DATA_DIR, newSchemaInfo.schemaName);
  if (mkdir(dirFileName, 0755) == -1) {
    if (errno == EEXIST)
      return TABLE_EXIST;
    else
      ERR;
  }
  
  bzero(dataFileName, BUFFSIZE);
  sprintf(dataFileName, "%s/%s/%s/relation", getenv("HOME"), DATA_DIR, newSchemaInfo.schemaName);
  if ((fd = open(dataFileName, O_WRONLY|O_CREAT|O_TRUNC, 0644)) == -1) ERR;
  if (close(fd) == -1) ERR;

  bzero(garbageFileName, BUFFSIZE);
  sprintf(garbageFileName, "%s/%s/%s/garbage", getenv("HOME"), DATA_DIR, newSchemaInfo.schemaName);
  if ((fd = open(garbageFileName, O_WRONLY|O_CREAT|O_TRUNC, 0644)) == -1) ERR;
  if (close(fd) == -1) ERR;
  
  bzero(schemaName, BUFFSIZE);
  sprintf(schemaName, "%s/%s/%s", getenv("HOME"), SCHEMA_DIR, newSchemaInfo.schemaName);
  
  if ((fp = fopen(schemaName, "w")) == NULL) ERR;
  for (p = newSchemaInfo.headAttrList.next; p != NULL; p = p->next) {
    fprintf(fp, "%s\t%s", p->attrName, p->attrType);
    if (strncmp(p->attrType, "sensor", strlen("sensor")) == 0) {
      bzero(dataFileName, BUFFSIZE);
      sprintf(dataFileName, "%s/%s/%s/sensor", getenv("HOME"), DATA_DIR, newSchemaInfo.schemaName);
      if ((mkdir(dataFileName, 0755) == -1) && (errno != EEXIST)) ERR;
      bzero(dataFileName, BUFFSIZE);
      sprintf(dataFileName, "%s/%s/%s/sensor/%s", getenv("HOME"), DATA_DIR, newSchemaInfo.schemaName, p->attrName);
      if ((mkdir(dataFileName, 0755) == -1) && (errno != EEXIST)) ERR;
      
      fprintf(fp, "\t%d", p->szsa);
    }
    fprintf(fp, "\n");
  }

  if (fclose(fp) != 0) ERR;

  return PARSE_OK;
}

static void
execCreateTableForMemory(NEW_SCHEMA_INFO newSchemaInfo)
{
  SCHEMA *schemaP;

  for (schemaP = &HeadSchema; schemaP->next != NULL; schemaP = schemaP->next) 
    ;
  if ((schemaP->next = calloc(1, sizeof(SCHEMA))) == NULL) ERR;
  schemaP = schemaP->next;

  setAttrInSchema(newSchemaInfo.schemaName, schemaP);
  initLockOfThisSchema(schemaP);
}

static PARSE_MSG
execCreateTable(NEW_SCHEMA_INFO newSchemaInfo)
{
  if (execCreateTableForDisk(newSchemaInfo) == TABLE_EXIST)
    return TABLE_EXIST;

  execCreateTableForMemory(newSchemaInfo);
  
  return PARSE_OK;
}

static int
skipCreate(const char buff[])
{
  int offset;

  for (offset = 0; offset < BUFFSIZE; offset++) {
    if ((buff[offset] == 'c') && 
        (strncmp(&buff[offset], "create", strlen("create")) == 0)) { 
      offset += strlen("create");
      for (; offset < BUFFSIZE; offset++) {
        if ((buff[offset] == 't') && 
            (strncmp(&buff[offset], "table", strlen("table")) == 0)) { 
          offset += strlen("table");
          break;
        }
      }
      break;
    }
  }

  while (buff[offset] == ' ') 
    offset++;

  return offset;
}

static char *
getNextOfLeftBracket(char *ptr)
{
  while (*ptr != '(') 
    ptr++;

  ptr++; /* skip '(' */

  return ptr;
}

static char *
setAttrName(ATTR_LIST *pAttrList, char *ptr)
{
  int attrNameId = 0;

  while (*ptr != ' ') {
    pAttrList->attrName[attrNameId] = *ptr;
    ptr++;
    attrNameId++;
  }

  while (*ptr == ' ') 
    ptr++;

  return ptr;
}

static char *
setAttrType(ATTR_LIST *pAttrList, char *p)
{
  int i = 0;

  while ((*p != ',') && (*p != ' ') && (*p != ')') && (*p != '[')) {
    pAttrList->attrType[i] = *p;
    p++;
    i++;
  }

  if (strcmp(pAttrList->attrType, "sensor") == 0) {
    int j = 0;
    char buff[BUFSIZ];

    bzero(buff, BUFSIZ);

    while (!isdigit(*p)) 
      p++;

    while (isdigit(*p)) 
      buff[j++] = *p++;

    pAttrList->szsa = atoi(buff);
    D(pAttrList->szsa);

    while (*p != ']') 
      p++;
    p++; /* skip ']' */
  }

  while (*p == ' ') 
    p++;

  if (*p == ',') {
    p++;
    while (*p == ' ') 
      p++;
  }

  return p;
}

static NEW_SCHEMA_INFO
getNewSchemaInfo(char givenBuff[])
{
  int nameid, buffid;
  char *ptr;
  char buff[QUERY_BUFFSIZE];
  ATTR_LIST *pAttrList;
  NEW_SCHEMA_INFO newSchemaInfo;

  memcpy(buff, givenBuff, QUERY_BUFFSIZE);
  bzero(&newSchemaInfo, sizeof(NEW_SCHEMA_INFO));
  buffid = skipCreate(buff);
  ptr = &buff[buffid];
  nameid = 0;
  while (*ptr != ' ') {
    newSchemaInfo.schemaName[nameid] = *ptr;
    nameid++;
    ptr++;
  }
  ptr = getNextOfLeftBracket(ptr);

  while (*ptr == ' ') 
    ptr++;

  pAttrList = &newSchemaInfo.headAttrList;
  while (*ptr != ')') {
    if ((pAttrList->next = calloc(1, sizeof(ATTR_LIST))) == NULL) 
      ERR;

    pAttrList = pAttrList->next;
    ptr = setAttrName(pAttrList, ptr);
    ptr = setAttrType(pAttrList, ptr);    

    if (strcmp(pAttrList->attrType, "int") == 0) {
      newSchemaInfo.schemaSize += sizeof(int);
    }
    else if (strcmp(pAttrList->attrType, "double") == 0) {
      newSchemaInfo.schemaSize += sizeof(double);
    }
    else if (strcmp(pAttrList->attrType, "text") == 0) {
      newSchemaInfo.schemaSize += BUFFSIZE;
    }
    else if (strcmp(pAttrList->attrType, "sensor") == 0) {
      newSchemaInfo.schemaSize += sizeof(SENSOR_SEGMENT);
    }
  }

  return newSchemaInfo;
}

static void
releaseNewSchemaInfo(NEW_SCHEMA_INFO newSchemaInfo)
{
  ATTR_LIST *pAttrList;

  while (newSchemaInfo.headAttrList.next != NULL) {
    pAttrList = newSchemaInfo.headAttrList.next;
    newSchemaInfo.headAttrList.next = newSchemaInfo.headAttrList.next->next;
    free(pAttrList);
  }
}

/****************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern PARSE_MSG
createTable(char query[QUERY_BUFFSIZE])
{
  PARSE_MSG parseMsg = PARSE_OK;
  NEW_SCHEMA_INFO newSchemaInfo;

  newSchemaInfo = getNewSchemaInfo(query);
  parseMsg = execCreateTable(newSchemaInfo);
  releaseNewSchemaInfo(newSchemaInfo);

  return parseMsg;
}
